/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.query.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class QueryCache {
    private static final Log log = (Log)LogFactory.getLog(QueryCache.class, Log.class);
    public static final String QUERY_CACHE_NAME = "___query_cache";
    private static final long MAX_ENTRIES = 200L;
    private static final long ENTRY_LIFESPAN = 300L;
    @Inject
    private EmbeddedCacheManager cacheManager;
    @Inject
    private InternalCacheRegistry internalCacheRegistry;
    private volatile Cache<QueryCacheKey, Object> lazyCache;

    public <T> T get(String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator, QueryCreator<T> queryCreator) {
        QueryCacheKey key = new QueryCacheKey(queryString, accumulators, queryTypeDiscriminator);
        return (T)this.getCache().computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> queryCreator.create(k.queryString, k.accumulators));
    }

    public void clear() {
        this.getCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<QueryCacheKey, Object> getCache() {
        Cache<QueryCacheKey, Object> cache = this.lazyCache;
        if (cache != null) {
            return cache;
        }
        QueryCache queryCache = this;
        synchronized (queryCache) {
            if (this.lazyCache == null) {
                this.internalCacheRegistry.registerInternalCache(QUERY_CACHE_NAME, this.getQueryCacheConfig().build(), EnumSet.noneOf(InternalCacheRegistry.Flag.class));
                this.lazyCache = this.cacheManager.getCache(QUERY_CACHE_NAME);
            }
            return this.lazyCache;
        }
    }

    private ConfigurationBuilder getQueryCacheConfig() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).expiration().maxIdle(300L, TimeUnit.SECONDS).memory().evictionType(EvictionType.COUNT).size(200L);
        return cfgBuilder;
    }

    private static final class QueryCacheKey {
        final String queryString;
        final List<FieldAccumulator> accumulators;
        final Object queryTypeDiscriminator;

        QueryCacheKey(String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator) {
            this.queryString = queryString;
            this.accumulators = accumulators;
            this.queryTypeDiscriminator = queryTypeDiscriminator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueryCacheKey)) {
                return false;
            }
            QueryCacheKey other = (QueryCacheKey)obj;
            return this.queryString.equals(other.queryString) && (this.accumulators != null ? this.accumulators.equals(other.accumulators) : other.accumulators == null) && this.queryTypeDiscriminator.equals(other.queryTypeDiscriminator);
        }

        public int hashCode() {
            int result = this.queryString.hashCode();
            result = 31 * result + (this.accumulators != null ? this.accumulators.hashCode() : 0);
            result = 31 * result + this.queryTypeDiscriminator.hashCode();
            return result;
        }

        public String toString() {
            return "QueryCacheKey{queryString='" + this.queryString + '\'' + ", accumulators=" + this.accumulators + ", queryTypeDiscriminator=" + this.queryTypeDiscriminator + '}';
        }
    }

    @FunctionalInterface
    public static interface QueryCreator<Q> {
        public Q create(String var1, List<FieldAccumulator> var2);
    }
}

