/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.Objects;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.memcached.MemcachedMetadataBuilder;

public class MemcachedMetadata
implements Metadata {
    protected final long flags;
    protected final EntryVersion version;

    public MemcachedMetadata(long flags, EntryVersion version) {
        this.flags = flags;
        this.version = Objects.requireNonNull(version);
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return this.version;
    }

    public Metadata.Builder builder() {
        return new MemcachedMetadataBuilder().flags(this.flags).version(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemcachedMetadata that = (MemcachedMetadata)o;
        if (this.flags != that.flags) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = (int)(this.flags ^ this.flags >>> 32);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return "MemcachedMetadata{flags=" + this.flags + ", version=" + this.version + '}';
    }
}

