/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;

public class TxReadOnlyKeyCommand<K, V, R>
extends ReadOnlyKeyCommand<K, V, R> {
    public static final byte COMMAND_ID = 64;
    private List<Mutation<K, V, ?>> mutations;

    public TxReadOnlyKeyCommand() {
    }

    public TxReadOnlyKeyCommand(Object key, List<Mutation<K, V, ?>> mutations, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, null, params, keyDataConversion, valueDataConversion, componentRegistry);
        this.mutations = mutations;
        this.init(componentRegistry);
    }

    public TxReadOnlyKeyCommand(ReadOnlyKeyCommand other, List<Mutation<K, V, ?>> mutations, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(other.getKey(), other.f, params, keyDataConversion, valueDataConversion, componentRegistry);
        this.mutations = mutations;
        this.init(componentRegistry);
    }

    @Override
    public byte getCommandId() {
        return 64;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallCollection(this.mutations, (ObjectOutput)output, Mutations::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.mutations = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, Mutations::readFrom);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.mutations != null) {
            for (Mutation<K, V, ?> m : this.mutations) {
                m.inject(componentRegistry);
            }
        }
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.mutations == null || this.mutations.isEmpty()) {
            return super.perform(ctx);
        }
        MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(this.key);
        EntryViews.AccessLoggingReadWriteView rw = EntryViews.readWrite(entry, this.keyDataConversion, this.valueDataConversion);
        StatsEnvelope ret = null;
        for (Mutation mutation : this.mutations) {
            ret = (StatsEnvelope)mutation.apply(rw);
            entry.updatePreviousValue();
        }
        if (this.f != null) {
            ret = (StatsEnvelope)EntryViews.snapshot(this.f.apply(rw));
        }
        return Param.StatisticsMode.isSkip(this.params) ? ret : StatsEnvelope.create(ret, entry.isNull());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TxReadOnlyKeyCommand{");
        sb.append("key=").append(this.key);
        sb.append(", f=").append(this.f);
        sb.append(", mutations=").append(this.mutations);
        sb.append(", params=").append(this.params);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }
}

