/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.remoting.transport.impl.FilterMapResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.MultiTargetRequest;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.impl.SingleTargetRequest;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.remoting.transport.jgroups.ClusterView;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsBackupResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.SingleSiteRequest;
import org.infinispan.remoting.transport.jgroups.SiteMasterPickerImpl;
import org.infinispan.remoting.transport.jgroups.StaggeredRequest;
import org.infinispan.remoting.transport.jgroups.ThreadPoolProbeHandler;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.AnycastAddress;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteMasterPicker;
import org.jgroups.protocols.tom.TOA;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;

public class JGroupsTransport
implements Transport {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_LOOKUP = "channelLookup";
    public static final short REPLY_FLAGS = (short)(Message.Flag.NO_FC.value() | Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "default-configs/default-jgroups-udp.xml";
    private static final Log log = LogFactory.getLog(JGroupsTransport.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final CompletableFuture<Map<Address, Response>> EMPTY_RESPONSES_FUTURE = CompletableFuture.completedFuture(Collections.emptyMap());
    private static final short CORRELATOR_ID = 0;
    private static final short HEADER_ID = ClassConfigurator.getProtocolId(RequestCorrelator.class);
    private static final byte REQUEST = 0;
    private static final byte RESPONSE = 1;
    private static final byte SINGLE_MESSAGE = 2;
    @Inject
    protected GlobalConfiguration configuration;
    @Inject
    protected StreamingMarshaller marshaller;
    @Inject
    protected CacheManagerNotifier notifier;
    @Inject
    protected TimeService timeService;
    @Inject
    protected InboundInvocationHandler invocationHandler;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    protected ScheduledExecutorService timeoutExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.remote")
    protected ExecutorService remoteExecutor;
    private final Lock viewUpdateLock = new ReentrantLock();
    private final Condition viewUpdateCondition = this.viewUpdateLock.newCondition();
    private final ThreadPoolProbeHandler probeHandler;
    private final ChannelCallbacks channelCallbacks = new ChannelCallbacks();
    protected boolean connectChannel = true;
    protected boolean disconnectChannel = true;
    protected boolean closeChannel = true;
    protected TypedProperties props;
    protected JChannel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile ClusterView clusterView = new ClusterView(-1, Collections.emptyList(), null);
    private volatile Set<String> sitesView = Collections.emptySet();
    private CompletableFuture<Void> nextViewFuture = new CompletableFuture();
    private RequestRepository requests;
    private boolean globalStatsEnabled;
    private MBeanServer mbeanServer;
    private String domain;

    public JGroupsTransport(JChannel channel) {
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
        this.probeHandler = new ThreadPoolProbeHandler();
    }

    public JGroupsTransport() {
        this.probeHandler = new ThreadPoolProbeHandler();
    }

    private static List<org.jgroups.Address> toJGroupsAddressList(Collection<Address> addresses) {
        if (addresses == null) {
            return null;
        }
        return addresses.stream().map(JGroupsTransport::toJGroupsAddress).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) {
        boolean broadcast;
        if (recipients != null && recipients.isEmpty()) {
            log.tracef("Destination list is empty: no need to send command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        ClusterView view = this.clusterView;
        List<Address> localMembers = view.getMembers();
        int membersSize = localMembers.size();
        boolean ignoreLeavers = mode == ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == ResponseMode.WAIT_FOR_VALID_RESPONSE;
        boolean totalOrder = deliverOrder == DeliverOrder.TOTAL;
        boolean sendStaggeredRequest = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE && deliverOrder == DeliverOrder.NONE && recipients != null && recipients.size() > 1 && timeout > 0L;
        boolean rsvp = JGroupsTransport.isRsvpCommand(command);
        boolean bl = broadcast = recipients == null;
        if (!totalOrder && recipients == null && membersSize == 1) {
            log.tracef("The cluster has a single node: no need to broadcast command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        Address singleTarget = this.computeSingleTarget(recipients, localMembers, membersSize, broadcast, totalOrder);
        if (!totalOrder && this.address.equals(singleTarget)) {
            log.tracef("Skipping request to self for command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        if (mode.isAsynchronous()) {
            return this.performAsyncRemoteInvocation(recipients, command, deliverOrder, rsvp, broadcast, singleTarget);
        }
        Collection<Address> actualTargets = broadcast ? localMembers : recipients;
        return this.performSyncRemoteInvocation(actualTargets, command, mode, timeout, responseFilter, deliverOrder, ignoreLeavers, sendStaggeredRequest, broadcast, singleTarget);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (destination.equals(this.address)) {
            if (trace) {
                log.tracef("%s not sending command to self: %s", this.address, command);
            }
            return;
        }
        this.logCommand(command, destination);
        this.sendCommand(destination, command, 0L, deliverOrder, JGroupsTransport.isRsvpCommand(command), true);
    }

    @Override
    public void sendToMany(Collection<Address> targets, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (targets == null) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder, false);
        } else {
            this.logCommand(command, targets);
            this.sendCommand(targets, command, 0L, deliverOrder, false);
        }
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> commands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        if (commands == null || commands.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return Collections.emptyMap();
        }
        if (mode.isSynchronous()) {
            MapResponseCollector collector = MapResponseCollector.validOnly(commands.size());
            CompletionStage request = this.invokeCommands(commands.keySet(), commands::get, (ResponseCollector)collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
            try {
                return (Map)CompletableFutures.await(request);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                cause.addSuppressed(e);
                throw Util.rewrapAsCacheException((Throwable)cause);
            }
        }
        commands.forEach((a, command) -> {
            this.logCommand((ReplicableCommand)command, a);
            this.sendCommand((Address)a, (ReplicableCommand)command, 0L, deliverOrder, JGroupsTransport.isRsvpCommand(command), true);
        });
        return Collections.emptyMap();
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand command) throws Exception {
        if (trace) {
            log.tracef("About to send to backups %s, command %s", backups, command);
        }
        boolean rsvp = JGroupsTransport.isRsvpCommand(command);
        HashMap<XSiteBackup, Future<Response>> syncBackupCalls = new HashMap<XSiteBackup, Future<Response>>(backups.size());
        for (XSiteBackup xsb : backups) {
            Address recipient = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)new SiteMaster(xsb.getSiteName()));
            if (xsb.isSync()) {
                long timeout = xsb.getTimeout();
                long requestId = this.requests.newRequestId();
                this.logRequest(requestId, command, recipient);
                SingleSiteRequest<Response> request = new SingleSiteRequest<Response>(PassthroughSingleResponseCollector.INSTANCE, requestId, this.requests, xsb.getSiteName());
                this.addRequest(request);
                try {
                    this.sendCommand(recipient, command, request.getRequestId(), DeliverOrder.NONE, rsvp, false);
                    if (timeout > 0L) {
                        request.setTimeout(this.timeoutExecutor, timeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Throwable t) {
                    request.cancel(true);
                    throw t;
                }
                syncBackupCalls.put(xsb, request);
                continue;
            }
            this.sendCommand(recipient, command, 0L, DeliverOrder.PER_SENDER, false, false);
        }
        return new JGroupsBackupResponse(syncBackupCalls, this.timeService);
    }

    @Override
    public boolean isCoordinator() {
        return this.clusterView.isCoordinator();
    }

    @Override
    public Address getCoordinator() {
        return this.clusterView.getCoordinator();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            org.jgroups.Address addr = (org.jgroups.Address)this.channel.down(new Event(87, (Object)this.channel.getAddress()));
            if (addr == null) {
                return Collections.emptyList();
            }
            this.physicalAddress = new JGroupsAddress(addr);
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public List<Address> getMembers() {
        return this.clusterView.getMembers();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public void start() {
        this.probeHandler.updateThreadPool(this.remoteExecutor);
        this.props = TypedProperties.toTypedProperties((Properties)this.configuration.transport().properties());
        this.requests = new RequestRepository();
        if (log.isInfoEnabled()) {
            log.startingJGroupsChannel(this.configuration.transport().clusterName());
        }
        this.initChannel();
        this.channel.setReceiver((Receiver)this.channelCallbacks);
        this.setXSiteViewListener(this.channelCallbacks);
        this.setSiteMasterPicker(new SiteMasterPickerImpl());
        this.startJGroupsChannelIfNeeded();
        this.waitForInitialNodes();
        this.channel.getProtocolStack().getTransport().registerProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
    }

    protected void initChannel() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (this.channel == null) {
            String transportNodeName;
            this.buildChannel();
            if (this.connectChannel && (transportNodeName = transportCfg.nodeName()) != null && transportNodeName.length() > 0) {
                long range = 65534L;
                long randomInRange = (long)(Math.random() * (double)range % (double)range) + 1L;
                transportNodeName = transportNodeName + "-" + randomInRange;
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.setDiscardOwnMessages(false);
        if (transportCfg.hasTopologyInfo()) {
            if (this.connectChannel) {
                this.channel.addAddressGenerator(() -> JGroupsTopologyAwareAddress.randomUUID(this.channel.getName(), transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId()));
            } else {
                org.jgroups.Address jgroupsAddress = this.channel.getAddress();
                if (jgroupsAddress instanceof ExtendedUUID) {
                    JGroupsTopologyAwareAddress address = new JGroupsTopologyAwareAddress((ExtendedUUID)jgroupsAddress);
                    if (!address.matches(transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId())) {
                        throw new CacheException("Topology information does not match the one set by the provided JGroups channel");
                    }
                } else {
                    throw new CacheException("JGroups address does not contain topology coordinates");
                }
            }
        }
    }

    private void setXSiteViewListener(RouteStatusListener listener) {
        RELAY2 relay2 = (RELAY2)this.channel.getProtocolStack().findProtocol(RELAY2.class);
        if (relay2 != null) {
            relay2.setRouteStatusListener(listener);
        }
    }

    private void setSiteMasterPicker(SiteMasterPickerImpl siteMasterPicker) {
        RELAY2 relay2 = (RELAY2)this.channel.getProtocolStack().findProtocol(RELAY2.class);
        if (relay2 != null) {
            relay2.siteMasterPicker((SiteMasterPicker)siteMasterPicker);
        }
    }

    private void startJGroupsChannelIfNeeded() {
        String clusterName = this.configuration.transport().clusterName();
        if (this.connectChannel) {
            try {
                this.channel.connect(clusterName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups Channel", (Throwable)e);
            }
            try {
                this.globalStatsEnabled = this.configuration.globalJmxStatistics().enabled();
                if (this.globalStatsEnabled) {
                    String groupName = String.format("type=channel,cluster=%s", ObjectName.quote(clusterName));
                    this.mbeanServer = JmxUtil.lookupMBeanServer(this.configuration);
                    this.domain = JmxUtil.buildJmxDomain(this.configuration, this.mbeanServer, groupName);
                    JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)this.mbeanServer, (String)this.domain, (String)clusterName, (boolean)true);
                }
            }
            catch (Exception e) {
                throw new CacheException("Channel connected, but unable to register MBeans", (Throwable)e);
            }
        }
        if (!this.connectChannel) {
            this.receiveClusterView(this.channel.getView());
        }
        if (log.isInfoEnabled()) {
            log.localAndPhysicalAddress(clusterName, this.getAddress(), this.getPhysicalAddresses());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialNodes() {
        int initialClusterSize = this.configuration.transport().initialClusterSize();
        if (initialClusterSize <= 1) {
            return;
        }
        long timeout = this.configuration.transport().initialClusterTimeout();
        long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.channel.getView().getMembers().size() < initialClusterSize && remainingNanos > 0L) {
                log.debugf("Waiting for %d nodes, current view has %d", initialClusterSize, this.channel.getView().getMembers().size());
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        catch (InterruptedException e) {
            log.interruptedWaitingForCoordinator(e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
        if (remainingNanos <= 0L) {
            throw log.timeoutWaitingForInitialNodes(initialClusterSize, this.channel.getView().getMembers());
        }
        log.debugf("Initial cluster size of %d nodes reached", initialClusterSize);
    }

    private void buildChannel() {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        if (this.props != null) {
            String cfg;
            if (this.props.containsKey((Object)CHANNEL_LOOKUP)) {
                String channelLookupClassName = this.props.getProperty(CHANNEL_LOOKUP);
                try {
                    JGroupsChannelLookup lookup = (JGroupsChannelLookup)Util.getInstance((String)channelLookupClassName, (ClassLoader)this.configuration.classLoader());
                    this.channel = lookup.getJGroupsChannel((Properties)this.props);
                    this.connectChannel = lookup.shouldConnect();
                    this.disconnectChannel = lookup.shouldDisconnect();
                    this.closeChannel = lookup.shouldClose();
                }
                catch (ClassCastException e) {
                    log.wrongTypeForJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException((Throwable)e);
                }
                catch (Exception e) {
                    log.errorInstantiatingJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException((Throwable)e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                Collection<Object> confs = Collections.emptyList();
                try {
                    confs = fileLookup.lookupFileLocations(cfg, this.configuration.classLoader());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (confs.isEmpty()) {
                    throw log.jgroupsConfigurationNotFound(cfg);
                }
                if (confs.size() > 1) {
                    log.ambiguousConfigurationFiles(Util.toStr(confs));
                }
                try {
                    this.channel = new JChannel((URL)confs.iterator().next());
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromConfigFile(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XmlConfigHelper.stringToElement(cfg));
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromXML(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel((InputStream)new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw log.errorCreatingChannelFromConfigString(cfg, e);
                }
            }
        }
        if (this.channel == null) {
            log.unableToUseJGroupsPropertiesProvided(this.props);
            try {
                this.channel = new JChannel(fileLookup.lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.classLoader()));
            }
            catch (Exception e) {
                throw log.errorCreatingChannelFromConfigFile(DEFAULT_JGROUPS_CONFIGURATION_FILE, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveClusterView(View newView) {
        boolean hasNotifier;
        List<List<Address>> subGroups;
        if (this.address == null) {
            this.address = JGroupsAddressCache.fromJGroupsAddress(this.channel.getAddress());
        }
        if (newView instanceof MergeView) {
            LogFactory.CLUSTER.receivedMergedView(this.channel.clusterName(), newView);
            subGroups = new ArrayList();
            List jgroupsSubGroups = ((MergeView)newView).getSubgroups();
            for (View group : jgroupsSubGroups) {
                subGroups.add(JGroupsTransport.fromJGroupsAddressList(group.getMembers()));
            }
        } else {
            LogFactory.CLUSTER.receivedClusterView(this.channel.clusterName(), newView);
            subGroups = Collections.emptyList();
        }
        long viewId = newView.getViewId().getId();
        List<Address> members = JGroupsTransport.fromJGroupsAddressList(newView.getMembers());
        if (members.isEmpty()) {
            return;
        }
        ClusterView oldView = this.clusterView;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            if (log.isDebugEnabled() && oldView.getMembers() != null) {
                ArrayList<Address> joined = new ArrayList<Address>(members);
                joined.removeAll(oldView.getMembers());
                ArrayList<Address> left = new ArrayList<Address>(oldView.getMembers());
                left.removeAll(members);
                log.debugf("Joined: %s, Left: %s", joined, left);
            }
            this.clusterView = new ClusterView((int)viewId, members, this.address);
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                CompletableFuture<Void> future = oldFuture;
                this.remoteExecutor.execute(() -> future.complete(null));
            }
        }
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            if (!subGroups.isEmpty()) {
                Address address1 = this.getAddress();
                this.notifier.notifyMerge(members, oldView.getMembers(), address1, (int)viewId, subGroups);
            } else {
                this.notifier.notifyViewChange(members, oldView.getMembers(), this.getAddress(), (int)viewId);
            }
        }
        this.remoteExecutor.execute(() -> {
            if (this.requests != null) {
                this.requests.forEach(request -> request.onNewView(this.clusterView.getMembersSet()));
            }
        });
        JGroupsAddressCache.pruneAddressCache();
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        return Collections.unmodifiableList(list.stream().map(JGroupsAddressCache::fromJGroupsAddress).collect(Collectors.toList()));
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            this.channel.getProtocolStack().getTransport().unregisterProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
        }
        String clusterName = this.configuration.transport().clusterName();
        try {
            if (this.disconnectChannel && this.channel != null && this.channel.isConnected()) {
                log.disconnectJGroups(clusterName);
                if (this.globalStatsEnabled) {
                    JmxConfigurator.unregisterChannel((JChannel)this.channel, (MBeanServer)this.mbeanServer, (String)this.domain, (String)this.channel.getClusterName());
                }
                this.channel.disconnect();
            }
            if (this.closeChannel && this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.problemClosingChannel(toLog, clusterName);
        }
        if (this.requests != null) {
            this.requests.forEach(request -> request.cancel((Exception)((Object)log.cacheManagerIsStopping())));
        }
        this.channel = null;
        this.address = null;
        this.physicalAddress = null;
        this.clusterView = new ClusterView(Integer.MAX_VALUE, Collections.emptyList(), null);
        this.requests = null;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new CacheException("The cache has been stopped and invocations are not allowed!");
        }
        return this.clusterView.getViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> withView(int expectedViewId) {
        ClusterView view = this.clusterView;
        if (view.isViewIdAtLeast(expectedViewId)) {
            return CompletableFutures.completedNull();
        }
        if (trace) {
            log.tracef("Waiting for transaction data for view %d, current view is %d", expectedViewId, view.getViewId());
        }
        this.viewUpdateLock.lock();
        try {
            view = this.clusterView;
            if (view.isViewIdAtLeast(Integer.MAX_VALUE)) {
                throw new IllegalLifecycleStateException();
            }
            if (view.isViewIdAtLeast(expectedViewId)) {
                CompletableFuture<Void> completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            CompletionStage completionStage = this.nextViewFuture.thenCompose(nil -> this.withView(expectedViewId));
            return completionStage;
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForView(int viewId) throws InterruptedException {
        if (this.channel == null) {
            return;
        }
        log.tracef("Waiting on view %d being accepted", viewId);
        long remainingNanos = Long.MAX_VALUE;
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.getViewId() < viewId && remainingNanos > 0L) {
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public final void checkTotalOrderSupported() {
        if (this.channel.getProtocolStack().findProtocol(TOA.class) == null) {
            throw new CacheConfigurationException("In order to support total order based transaction, the TOA protocol must be present in the JGroups's config.");
        }
    }

    @Override
    public Set<String> getSitesView() {
        return this.sitesView;
    }

    public <T> CompletableFuture<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        if (target.equals(this.address) && deliverOrder != DeliverOrder.TOTAL) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, target);
        SingleTargetRequest<T> request = new SingleTargetRequest<T>(collector, requestId, this.requests, target);
        this.addRequest(request);
        this.sendCommand(target, command, requestId, deliverOrder, JGroupsTransport.isRsvpCommand(command), true);
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    public <T> CompletableFuture<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, targets);
        if (targets.isEmpty()) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        Address excludedTarget = deliverOrder == DeliverOrder.TOTAL ? null : this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget);
        try {
            this.addRequest(request);
            this.sendCommand(targets, command, requestId, deliverOrder, JGroupsTransport.isRsvpCommand(command));
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    public <T> CompletableFuture<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, "all");
        Address excludedTarget = deliverOrder == DeliverOrder.TOTAL ? null : this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, this.clusterView.getMembers(), excludedTarget);
        try {
            this.addRequest(request);
            this.sendCommandToAll(command, requestId, deliverOrder, JGroupsTransport.isRsvpCommand(command));
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    public <T> CompletableFuture<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, "staggered " + targets);
        StaggeredRequest<T> request = new StaggeredRequest<T>(collector, requestId, this.requests, targets, this.getAddress(), command, deliverOrder, timeout, unit, this);
        try {
            this.addRequest(request);
            request.sendNextMessage();
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        return request;
    }

    public <T> CompletableFuture<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        long requestId = this.requests.newRequestId();
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget);
        this.addRequest(request);
        try {
            for (Address target : targets) {
                ReplicableCommand command = commandGenerator.apply(target);
                boolean rsvp = JGroupsTransport.isRsvpCommand(command);
                this.logRequest(requestId, command, target);
                this.sendCommand(target, command, requestId, deliverOrder, rsvp, true);
            }
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, timeUnit);
        }
        return request;
    }

    private void addRequest(AbstractRequest<?> request) {
        try {
            this.requests.addRequest(request);
            request.onNewView(this.clusterView.getMembersSet());
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
    }

    void sendCommand(Address target, ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean rsvp, boolean noRelay) {
        Message message = new Message(JGroupsTransport.toJGroupsAddress(target));
        this.marshallRequest(message, command, requestId);
        JGroupsTransport.setMessageFlags(message, deliverOrder, rsvp, noRelay);
        this.send(message);
    }

    private static boolean isRsvpCommand(ReplicableCommand command) {
        return command instanceof FlagAffectedCommand && ((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.GUARANTEED_DELIVERY);
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        return ((JGroupsAddress)address).getJGroupsAddress();
    }

    private void marshallRequest(Message message, ReplicableCommand command, long requestId) {
        try {
            ByteBuffer bytes = this.marshaller.objectToBuffer((Object)command);
            message.setBuffer(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
            this.addRequestHeader(message, requestId);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
    }

    private static void setMessageFlags(Message message, DeliverOrder deliverOrder, boolean rsvp, boolean noRelay) {
        if (noRelay) {
            message.setFlag(Message.Flag.NO_RELAY.value());
        }
        short flags = JGroupsTransport.encodeDeliverMode(deliverOrder);
        message.setFlag(flags);
        if (deliverOrder != DeliverOrder.TOTAL) {
            message.setTransientFlag(Message.TransientFlag.DONT_LOOPBACK.value());
        }
        if (rsvp) {
            message.setFlag(Message.Flag.RSVP.value());
        }
    }

    private void send(Message message) {
        try {
            this.channel.send(message);
        }
        catch (Exception e) {
            if (this.channel != null && this.channel.isConnected()) {
                throw new CacheException((Throwable)e);
            }
            throw log.cacheManagerIsStopping();
        }
    }

    private void addRequestHeader(Message message, long requestId) {
        if (requestId != 0L) {
            RequestCorrelator.Header header = new RequestCorrelator.Header(0, requestId, 0);
            message.putHeader(HEADER_ID, (Header)header);
        }
    }

    private static short encodeDeliverMode(DeliverOrder deliverOrder) {
        switch (deliverOrder) {
            case TOTAL: {
                return Message.Flag.OOB.value();
            }
            case PER_SENDER: {
                return Message.Flag.NO_TOTAL_ORDER.value();
            }
            case NONE: {
                return (short)(Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
            }
        }
        throw new IllegalArgumentException("Unsupported deliver mode " + (Object)((Object)deliverOrder));
    }

    private Address computeSingleTarget(Collection<Address> targets, List<Address> localMembers, int membersSize, boolean broadcast, boolean totalOrder) {
        Address singleTarget;
        if (broadcast || totalOrder) {
            singleTarget = null;
        } else if (targets == null) {
            assert (membersSize == 2);
            singleTarget = localMembers.get(0).equals(this.address) ? localMembers.get(1) : localMembers.get(0);
        } else {
            singleTarget = targets.size() == 1 ? targets.iterator().next() : null;
        }
        return singleTarget;
    }

    private CompletableFuture<Map<Address, Response>> performAsyncRemoteInvocation(Collection<Address> recipients, ReplicableCommand command, DeliverOrder deliverOrder, boolean rsvp, boolean broadcast, Address singleTarget) {
        if (broadcast) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder, rsvp);
        } else if (singleTarget != null) {
            this.logCommand(command, singleTarget);
            this.sendCommand(singleTarget, command, 0L, deliverOrder, rsvp, true);
        } else {
            this.logCommand(command, recipients);
            this.sendCommand(recipients, command, 0L, deliverOrder, rsvp);
        }
        return EMPTY_RESPONSES_FUTURE;
    }

    private CompletableFuture<Map<Address, Response>> performSyncRemoteInvocation(Collection<Address> targets, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean ignoreLeavers, boolean sendStaggeredRequest, boolean broadcast, Address singleTarget) {
        CompletionStage request;
        if (sendStaggeredRequest) {
            FilterMapResponseCollector collector = new FilterMapResponseCollector(responseFilter, false, targets.size());
            request = this.invokeCommandStaggered((Collection)targets, command, (ResponseCollector)collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else if (singleTarget != null) {
            SingletonMapResponseCollector collector = ignoreLeavers ? SingletonMapResponseCollector.ignoreLeavers() : SingletonMapResponseCollector.validOnly();
            request = this.invokeCommand(singleTarget, command, (ResponseCollector)collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else {
            ValidResponseCollector collector = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE ? new FilterMapResponseCollector(responseFilter, false, targets.size()) : (responseFilter != null ? new FilterMapResponseCollector(responseFilter, true, targets.size()) : MapResponseCollector.ignoreLeavers(ignoreLeavers, targets.size()));
            request = broadcast ? this.invokeCommandOnAll(command, (ResponseCollector)collector, deliverOrder, timeout, TimeUnit.MILLISECONDS) : this.invokeCommand((Collection)targets, command, (ResponseCollector)collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        }
        return request;
    }

    @Override
    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.logCommand(command, "all");
        this.sendCommandToAll(command, 0L, deliverOrder, false);
    }

    private void sendCommandToAll(ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean rsvp) {
        Message message = new Message();
        this.marshallRequest(message, command, requestId);
        JGroupsTransport.setMessageFlags(message, deliverOrder, rsvp, true);
        if (deliverOrder == DeliverOrder.TOTAL) {
            message.dest((org.jgroups.Address)new AnycastAddress());
        }
        this.send(message);
    }

    private void logRequest(long requestId, ReplicableCommand command, Object targets) {
        if (trace) {
            log.tracef("%s sending request %d to %s: %s", new Object[]{this.address, requestId, targets, command});
        }
    }

    private void logCommand(ReplicableCommand command, Object targets) {
        if (trace) {
            log.tracef("%s sending command to %s: %s", this.address, targets, command);
        }
    }

    public JChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSitesView(Collection<String> sitesUp, Collection<String> sitesDown) {
        this.viewUpdateLock.lock();
        try {
            HashSet<String> reachableSites = new HashSet<String>(this.sitesView);
            reachableSites.addAll(sitesUp);
            reachableSites.removeAll(sitesDown);
            log.tracef("Sites view changed: up %s, down %s, new view is %s", sitesUp, sitesDown, reachableSites);
            log.receivedXSiteClusterView(reachableSites);
            this.sitesView = Collections.unmodifiableSet(reachableSites);
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    private void siteUnreachable(String site) {
        this.requests.forEach(request -> {
            if (request instanceof SingleSiteRequest) {
                ((SingleSiteRequest)request).sitesUnreachable(Collections.singleton(site));
            }
        });
    }

    private void sendCommand(Collection<Address> targets, ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean rsvp) {
        Objects.requireNonNull(targets);
        Message message = new Message();
        this.marshallRequest(message, command, requestId);
        JGroupsTransport.setMessageFlags(message, deliverOrder, rsvp, true);
        if (deliverOrder == DeliverOrder.TOTAL) {
            message.dest((org.jgroups.Address)new AnycastAddress(JGroupsTransport.toJGroupsAddressList(targets)));
            this.send(message);
        } else {
            Iterator<Address> it = targets.iterator();
            this.sendSkippingSelf(message, it.next());
            while (it.hasNext()) {
                Message copy = message.copy(true);
                this.sendSkippingSelf(copy, it.next());
            }
        }
    }

    private void sendSkippingSelf(Message message, Address address) {
        if (!address.equals(this.getAddress())) {
            message.dest(JGroupsTransport.toJGroupsAddress(address));
            this.send(message);
        }
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    private void processMessage(Message message) {
        long requestId;
        int type;
        org.jgroups.Address src = message.src();
        short flags = message.getFlags();
        byte[] buffer = message.rawBuffer();
        int offset = message.offset();
        int length = message.length();
        RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(HEADER_ID);
        if (header != null) {
            type = header.type;
            requestId = header.requestId();
        } else {
            type = 2;
            requestId = 0L;
        }
        if (this.address == null) {
            if (trace) {
                log.tracef("Ignoring message received before initial view", new Object[0]);
            }
            if (type == 0) {
                this.sendResponse(src, CacheNotFoundResponse.INSTANCE, requestId, null);
            }
            return;
        }
        switch (type) {
            case 0: 
            case 2: {
                this.processRequest(src, flags, buffer, offset, length, requestId);
                break;
            }
            case 1: {
                this.processResponse(src, buffer, offset, length, requestId);
                break;
            }
            default: {
                log.invalidMessageType(type, src);
            }
        }
    }

    private void sendResponse(org.jgroups.Address target, Response response, long requestId, ReplicableCommand command) {
        block9: {
            ByteBuffer bytes;
            JChannel channel;
            if (trace) {
                log.tracef("%s sending response for request %d to %s: %s", new Object[]{this.getAddress(), requestId, target, response});
            }
            if ((channel = this.channel) == null) {
                return;
            }
            try {
                bytes = this.marshaller.objectToBuffer((Object)response);
            }
            catch (Throwable t) {
                try {
                    Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
                    bytes = this.marshaller.objectToBuffer((Object)new ExceptionResponse((Exception)e));
                }
                catch (Throwable tt) {
                    if (channel.isConnected()) {
                        log.errorSendingResponse(requestId, target, command);
                    }
                    return;
                }
            }
            try {
                Message message = new Message(target).setFlag(REPLY_FLAGS);
                message.setBuffer(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
                RequestCorrelator.Header header = new RequestCorrelator.Header(1, requestId, 0);
                message.putHeader(HEADER_ID, (Header)header);
                channel.send(message);
            }
            catch (Throwable t) {
                if (!channel.isConnected()) break block9;
                log.errorSendingResponse(requestId, target, command);
            }
        }
    }

    private void processRequest(org.jgroups.Address src, short flags, byte[] buffer, int offset, int length, long requestId) {
        try {
            Reply reply;
            DeliverOrder deliverOrder = this.decodeDeliverMode(flags);
            if (deliverOrder != DeliverOrder.TOTAL && src.equals(((JGroupsAddress)this.getAddress()).getJGroupsAddress())) {
                if (trace) {
                    log.tracef("Ignoring request %d from self without total order", requestId);
                }
                return;
            }
            ReplicableCommand command = (ReplicableCommand)this.marshaller.objectFromByteBuffer(buffer, offset, length);
            if (requestId != 0L) {
                if (trace) {
                    log.tracef("%s received request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, command});
                }
                reply = response -> this.sendResponse(src, response, requestId, command);
            } else {
                if (trace) {
                    log.tracef("%s received command from %s: %s", this.getAddress(), src, command);
                }
                reply = Reply.NO_OP;
            }
            if (src instanceof SiteAddress) {
                String originSite = ((SiteAddress)src).getSite();
                ((XSiteReplicateCommand)command).setOriginSite(originSite);
                this.invocationHandler.handleFromRemoteSite(originSite, (XSiteReplicateCommand)command, reply, deliverOrder);
            } else {
                this.invocationHandler.handleFromCluster(JGroupsAddressCache.fromJGroupsAddress(src), command, reply, deliverOrder);
            }
        }
        catch (Throwable t) {
            log.errorProcessingRequest(requestId, src);
            Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
            this.sendResponse(src, new ExceptionResponse((Exception)e), requestId, null);
        }
    }

    private void processResponse(org.jgroups.Address src, byte[] buffer, int offset, int length, long requestId) {
        try {
            Response response;
            if (length == 0) {
                response = CacheNotFoundResponse.INSTANCE;
            } else {
                response = (Response)this.marshaller.objectFromByteBuffer(buffer, offset, length);
                if (response == null) {
                    response = SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE;
                }
            }
            if (trace) {
                log.tracef("%s received response for request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, response});
            }
            Address address = JGroupsAddressCache.fromJGroupsAddress(src);
            this.requests.addResponse(requestId, address, response);
        }
        catch (Throwable t) {
            log.errorProcessingResponse(requestId, src);
        }
    }

    private DeliverOrder decodeDeliverMode(short flags) {
        boolean noTotalOrder = Message.isFlagSet((short)flags, (Message.Flag)Message.Flag.NO_TOTAL_ORDER);
        boolean oob = Message.isFlagSet((short)flags, (Message.Flag)Message.Flag.OOB);
        if (!noTotalOrder && oob) {
            return DeliverOrder.TOTAL;
        }
        if (noTotalOrder && oob) {
            return DeliverOrder.NONE;
        }
        if (noTotalOrder) {
            return DeliverOrder.PER_SENDER;
        }
        throw new IllegalArgumentException("Unable to decode order from flags " + flags);
    }

    private class ChannelCallbacks
    implements Receiver,
    RouteStatusListener,
    UpHandler {
        private ChannelCallbacks() {
        }

        public void viewAccepted(View new_view) {
            JGroupsTransport.this.receiveClusterView(new_view);
        }

        public void sitesUp(String ... sites) {
            JGroupsTransport.this.updateSitesView(Arrays.asList(sites), Collections.emptyList());
        }

        public void sitesDown(String ... sites) {
            JGroupsTransport.this.updateSitesView(Collections.emptyList(), Arrays.asList(sites));
        }

        public void receive(Message message) {
            JGroupsTransport.this.processMessage(message);
        }

        public void receive(MessageBatch batch) {
            batch.forEach((message, messages) -> JGroupsTransport.this.processMessage(message));
        }

        public Object up(Event evt) {
            switch (evt.getType()) {
                case 104: {
                    JGroupsTransport.this.siteUnreachable((String)evt.getArg());
                }
            }
            return null;
        }

        public Object up(Message msg) {
            return null;
        }

        public void up(MessageBatch batch) {
        }
    }
}

