/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.LostDataCheck;
import org.infinispan.partitionhandling.impl.PreferAvailabilityStrategy;
import org.infinispan.partitionhandling.impl.PreferConsistencyStrategy;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.RebalanceType;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.HeartBeatCommand;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;

public class ClusterTopologyManagerImpl
implements ClusterTopologyManager {
    public static final int INITIAL_CONNECTION_ATTEMPTS = 10;
    public static final int CLUSTER_RECOVERY_ATTEMPTS = 10;
    private static final Log log = LogFactory.getLog(ClusterTopologyManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private Transport transport;
    @Inject
    private GlobalConfiguration globalConfiguration;
    @Inject
    private GlobalComponentRegistry gcr;
    @Inject
    private CacheManagerNotifier cacheManagerNotifier;
    @Inject
    private EmbeddedCacheManager cacheManager;
    @Inject
    @ComponentName(value="org.infinispan.executors.transport")
    private ExecutorService asyncTransportExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.stateTransferExecutor")
    private ExecutorService stateTransferExecutor;
    @Inject
    private EventLogManager eventLogManager;
    @Inject
    private PersistentUUIDManager persistentUUIDManager;
    private volatile int viewId = -1;
    private volatile ClusterManagerStatus clusterManagerStatus = ClusterManagerStatus.INITIALIZING;
    private final Lock clusterManagerLock = new ReentrantLock();
    private final Condition clusterStateChanged = this.clusterManagerLock.newCondition();
    private final ConcurrentMap<String, ClusterCacheStatus> cacheStatusMap = CollectionFactory.makeConcurrentMap();
    private ClusterViewListener viewListener;
    private LimitedExecutor viewHandlingExecutor;
    private volatile boolean globalRebalancingEnabled = true;

    @Start(priority=100)
    public void start() {
        this.viewHandlingExecutor = new LimitedExecutor("ViewHandling", this.asyncTransportExecutor, 1);
        this.viewListener = new ClusterViewListener();
        this.cacheManagerNotifier.addListener(this.viewListener);
        this.viewHandlingExecutor.execute(() -> this.handleClusterView(false, this.transport.getViewId()));
        this.fetchRebalancingStatusFromCoordinator();
    }

    protected void fetchRebalancingStatusFromCoordinator() {
        if (!this.transport.isCoordinator()) {
            CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), -1);
            Address coordinator = null;
            Response response = null;
            for (int i = 9; i >= 0; --i) {
                try {
                    coordinator = this.transport.getCoordinator();
                    Map<Address, Response> responseMap = this.transport.invokeRemotely(Collections.singleton(coordinator), command, ResponseMode.SYNCHRONOUS, this.getGlobalTimeout() / 10, null, DeliverOrder.NONE, false);
                    response = responseMap.get(coordinator);
                    break;
                }
                catch (Exception e) {
                    if (i == 0 || !(e instanceof TimeoutException)) {
                        log.errorReadingRebalancingStatus(coordinator, e);
                        response = SuccessfulResponse.create(Boolean.TRUE);
                    }
                    log.debug("Timed out waiting for rebalancing status from coordinator, trying again");
                    continue;
                }
            }
            if (response instanceof SuccessfulResponse) {
                this.globalRebalancingEnabled = (Boolean)((SuccessfulResponse)response).getResponseValue();
            } else {
                log.errorReadingRebalancingStatus(coordinator, (Exception)((Object)new CacheException(Objects.toString(response))));
            }
        }
    }

    @Stop(priority=100)
    public void stop() {
        this.clusterManagerLock.lock();
        try {
            this.clusterManagerStatus = ClusterManagerStatus.STOPPING;
            this.clusterStateChanged.signalAll();
        }
        finally {
            this.clusterManagerLock.unlock();
        }
        if (this.viewListener != null) {
            this.cacheManagerNotifier.removeListener(this.viewListener);
        }
        if (this.viewHandlingExecutor != null) {
            this.viewHandlingExecutor.cancelQueuedTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheStatusResponse handleJoin(String cacheName, Address joiner, CacheJoinInfo joinInfo, int joinerViewId) throws Exception {
        ClusterCacheStatus cacheStatus;
        this.clusterManagerLock.lock();
        try {
            this.waitForJoinerView(joiner, joinerViewId, joinInfo.getTimeout());
            if (!this.clusterManagerStatus.isRunning()) {
                log.debugf("Ignoring join request from %s for cache %s, the local cache manager is shutting down", joiner, cacheName);
                CacheStatusResponse cacheStatusResponse = null;
                return cacheStatusResponse;
            }
            if (joinerViewId < this.viewId) {
                log.debugf("Ignoring join request from %s for cache %s, joiner's view id is too old: %d", joiner, cacheName, joinerViewId);
                CacheStatusResponse cacheStatusResponse = null;
                return cacheStatusResponse;
            }
            cacheStatus = this.initCacheStatusIfAbsent(cacheName, joinInfo.getCacheMode());
        }
        finally {
            this.clusterManagerLock.unlock();
        }
        return cacheStatus.doJoin(joiner, joinInfo);
    }

    @Override
    public void handleLeave(String cacheName, Address leaver, int viewId) throws Exception {
        if (!this.clusterManagerStatus.isRunning()) {
            log.debugf("Ignoring leave request from %s for cache %s, the local cache manager is shutting down", leaver, cacheName);
            return;
        }
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring leave request from %s for cache %s because it doesn't have a cache status entry", leaver, cacheName);
            return;
        }
        if (cacheStatus.doLeave(leaver)) {
            this.cacheStatusMap.remove(cacheName);
        }
    }

    @Override
    public void handleRebalancePhaseConfirm(String cacheName, Address node, int topologyId, Throwable throwable, int viewId) throws Exception {
        if (throwable != null) {
            log.rebalanceError(cacheName, node, topologyId, throwable);
        }
        LogFactory.CLUSTER.rebalanceCompleted(cacheName, node, topologyId);
        this.eventLogManager.getEventLogger().context(cacheName).scope(node.toString()).info(EventLogCategory.CLUSTER, Messages.MESSAGES.rebalancePhaseConfirmed(node, topologyId));
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null) {
            log.debugf("Ignoring rebalance confirmation from %s for cache %s because it doesn't have a cache status entry", node, cacheName);
            return;
        }
        cacheStatus.confirmRebalancePhase(node, topologyId);
    }

    private void handleClusterView(boolean mergeView, int newViewId) {
        try {
            if (!this.updateClusterState(mergeView, newViewId)) {
                return;
            }
            if (this.clusterManagerStatus == ClusterManagerStatus.RECOVERING_CLUSTER && !this.becomeCoordinator(newViewId)) {
                return;
            }
            if (this.clusterManagerStatus == ClusterManagerStatus.COORDINATOR) {
                this.updateCacheMembers(this.transport.getMembers());
            }
        }
        catch (Throwable t) {
            log.viewHandlingError(newViewId, t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean becomeCoordinator(int newViewId) {
        this.cacheStatusMap.clear();
        try {
            this.recoverClusterStatus(newViewId, this.transport.getMembers());
            this.clusterManagerLock.lock();
            try {
                if (this.viewId != newViewId) {
                    log.debugf("View updated while we were recovering the cluster for view %d", newViewId);
                    boolean bl = false;
                    return bl;
                }
                this.clusterManagerStatus = ClusterManagerStatus.COORDINATOR;
                this.clusterStateChanged.signalAll();
                return true;
            }
            finally {
                this.clusterManagerLock.unlock();
            }
        }
        catch (InterruptedException e) {
            if (!trace) return true;
            log.tracef("Cluster state recovery interrupted because the coordinator is shutting down", new Object[0]);
            return true;
        }
        catch (SuspectException e) {
            if (!trace) return true;
            log.tracef("Cluster state recovery interrupted because a member was lost. Will retry.", new Object[0]);
            return true;
        }
        catch (Exception e) {
            if (this.clusterManagerStatus.isRunning()) {
                LogFactory.CLUSTER.failedToRecoverClusterState(e);
                this.eventLogManager.getEventLogger().detail(e).fatal(EventLogCategory.CLUSTER, Messages.MESSAGES.clusterRecoveryFailed(this.transport.getMembers()));
                return true;
            }
            log.tracef("Cluster state recovery failed because the coordinator is shutting down", new Object[0]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateClusterState(boolean mergeView, int newViewId) {
        this.clusterManagerLock.lock();
        try {
            boolean becameCoordinator;
            if (newViewId < this.transport.getViewId()) {
                log.tracef("Ignoring old cluster view notification: %s", newViewId);
                boolean bl = false;
                return bl;
            }
            boolean isCoordinator = this.transport.isCoordinator();
            boolean bl = becameCoordinator = isCoordinator && !this.clusterManagerStatus.isCoordinator();
            if (trace) {
                log.tracef("Received new cluster view: %d, isCoordinator = %s, old status = %s", newViewId, isCoordinator, (Object)this.clusterManagerStatus);
            }
            if (!isCoordinator) {
                this.clusterManagerStatus = ClusterManagerStatus.REGULAR_MEMBER;
                boolean bl2 = false;
                return bl2;
            }
            if (becameCoordinator || mergeView) {
                this.clusterManagerStatus = ClusterManagerStatus.RECOVERING_CLUSTER;
            }
            this.viewId = newViewId;
            this.clusterStateChanged.signalAll();
        }
        finally {
            this.clusterManagerLock.unlock();
        }
        return true;
    }

    private ClusterCacheStatus initCacheStatusIfAbsent(String cacheName, CacheMode cacheMode) {
        return this.cacheStatusMap.computeIfAbsent(cacheName, name -> {
            LostDataCheck lostDataCheck = cacheMode.isScattered() ? ClusterTopologyManagerImpl::scatteredLostDataCheck : ClusterTopologyManagerImpl::distLostDataCheck;
            Configuration config = this.cacheManager.getCacheConfiguration(cacheName);
            PartitionHandling partitionHandling = config != null ? config.clustering().partitionHandling().whenSplit() : null;
            boolean resolveConflictsOnMerge = this.resolveConflictsOnMerge(config, cacheMode);
            AvailabilityStrategy availabilityStrategy = partitionHandling != null && partitionHandling != PartitionHandling.ALLOW_READ_WRITES ? new PreferConsistencyStrategy(this.eventLogManager, this.persistentUUIDManager, lostDataCheck) : new PreferAvailabilityStrategy(this.eventLogManager, this.persistentUUIDManager, lostDataCheck);
            Optional<GlobalStateManager> globalStateManager = this.gcr.getOptionalComponent(GlobalStateManager.class);
            Optional<ScopedPersistentState> persistedState = globalStateManager.flatMap(gsm -> gsm.readScopedState(cacheName));
            return new ClusterCacheStatus(this.cacheManager, cacheName, availabilityStrategy, RebalanceType.from(cacheMode), this, this.transport, persistedState, this.persistentUUIDManager, resolveConflictsOnMerge);
        });
    }

    private boolean resolveConflictsOnMerge(Configuration config, CacheMode cacheMode) {
        if (config == null || cacheMode.isScattered() || cacheMode.isInvalidation()) {
            return false;
        }
        return config.clustering().partitionHandling().resolveConflictsOnMerge();
    }

    @Override
    public void broadcastRebalanceStart(String cacheName, CacheTopology cacheTopology, boolean totalOrder, boolean distributed) {
        LogFactory.CLUSTER.startRebalance(cacheName, cacheTopology);
        this.eventLogManager.getEventLogger().context(cacheName).scope(this.transport.getAddress()).info(EventLogCategory.CLUSTER, Messages.MESSAGES.rebalanceStarted(cacheTopology.getTopologyId()));
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCE_START, this.transport.getAddress(), cacheTopology, null, this.viewId);
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    private void recoverClusterStatus(int newViewId, List<Address> clusterMembers) throws Exception {
        log.debugf("Recovering cluster status for view %d", newViewId);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.GET_STATUS, this.transport.getAddress(), newViewId);
        Map<Address, Object> statusResponses = null;
        for (int i = 9; i >= 0; --i) {
            try {
                statusResponses = this.executeOnClusterSync(command, this.getGlobalTimeout() / 10, false, false, new CacheTopologyFilterReuser());
                break;
            }
            catch (ExecutionException e) {
                if (i != 0) {
                    if (e.getCause() instanceof TimeoutException) {
                        log.debug("Timed out waiting for cluster status responses, trying again");
                        continue;
                    }
                    if (!(e.getCause() instanceof SuspectException) || !this.transport.getMembers().containsAll(clusterMembers)) continue;
                    int sleepTime = this.getGlobalTimeout() / 10 / 2;
                    log.debugf(e, "Received an exception from one of the members, will try again after %d ms", sleepTime);
                    Thread.sleep(sleepTime);
                    continue;
                }
                throw e;
            }
        }
        log.debugf("Got %d status responses. members are %s", statusResponses.size(), clusterMembers);
        HashMap<String, Map> responsesByCache = new HashMap<String, Map>();
        boolean recoveredRebalancingStatus = true;
        for (Map.Entry responseEntry : statusResponses.entrySet()) {
            Address sender = (Address)responseEntry.getKey();
            ManagerStatusResponse nodeStatus = (ManagerStatusResponse)responseEntry.getValue();
            recoveredRebalancingStatus &= nodeStatus.isRebalancingEnabled();
            for (Map.Entry<String, CacheStatusResponse> statusEntry : nodeStatus.getCaches().entrySet()) {
                String cacheName = statusEntry.getKey();
                Map cacheResponses = responsesByCache.computeIfAbsent(cacheName, k -> new HashMap());
                cacheResponses.put(sender, statusEntry.getValue());
            }
        }
        this.globalRebalancingEnabled = recoveredRebalancingStatus;
        int maxThreads = Runtime.getRuntime().availableProcessors() / 2 + 1;
        CountDownLatch latch = new CountDownLatch(responsesByCache.size());
        LimitedExecutor cs = new LimitedExecutor("Merge-" + newViewId, this.stateTransferExecutor, maxThreads);
        for (Map.Entry e : responsesByCache.entrySet()) {
            CacheJoinInfo joinInfo = ((CacheStatusResponse)((Map)e.getValue()).values().stream().findAny().get()).getCacheJoinInfo();
            ClusterCacheStatus cacheStatus = this.initCacheStatusIfAbsent((String)e.getKey(), joinInfo.getCacheMode());
            cs.execute(() -> {
                try {
                    cacheStatus.doMergePartitions((Map)e.getValue());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await(this.getGlobalTimeout(), TimeUnit.MILLISECONDS);
    }

    public void updateCacheMembers(List<Address> newClusterMembers) {
        block5: {
            try {
                log.tracef("Updating cluster members for all the caches. New list is %s", newClusterMembers);
                try {
                    this.confirmMembersAvailable();
                }
                catch (SuspectException e) {
                    log.tracef("Node %s left while updating cache members", e.getSuspect());
                    return;
                }
                for (ClusterCacheStatus cacheStatus : this.cacheStatusMap.values()) {
                    cacheStatus.doHandleClusterView();
                }
            }
            catch (Exception e) {
                if (!this.clusterManagerStatus.isRunning()) break block5;
                log.errorUpdatingMembersList(e);
            }
        }
    }

    private void confirmMembersAvailable() throws Exception {
        this.transport.invokeRemotely(null, HeartBeatCommand.INSTANCE, ResponseMode.SYNCHRONOUS, this.getGlobalTimeout(), null, DeliverOrder.NONE, false);
    }

    @GuardedBy(value="clusterManagerLock")
    private void waitForJoinerView(Address joiner, int joinerViewId, long timeout) throws InterruptedException {
        if (joinerViewId > this.viewId || this.clusterManagerStatus == ClusterManagerStatus.RECOVERING_CLUSTER) {
            if (trace) {
                if (joinerViewId > this.viewId) {
                    log.tracef("Waiting to install view %s before processing join request from %s", joinerViewId, joiner);
                } else {
                    log.tracef("Waiting to recover cluster status before processing join request from %s", joiner);
                }
            }
            long nanosTimeout = TimeUnit.MILLISECONDS.toNanos(timeout);
            while ((this.viewId < joinerViewId || this.clusterManagerStatus == ClusterManagerStatus.RECOVERING_CLUSTER) && this.clusterManagerStatus.isRunning()) {
                if (nanosTimeout <= 0L) {
                    throw log.coordinatorTimeoutWaitingForView(joinerViewId, this.transport.getViewId(), (Object)this.clusterManagerStatus);
                }
                nanosTimeout = this.clusterStateChanged.awaitNanos(nanosTimeout);
            }
        }
    }

    private Map<Address, Object> executeOnClusterSync(ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed, ResponseFilter filter) throws Exception {
        Response localResponse;
        if (totalOrder) {
            Map<Address, Response> responseMap = this.transport.invokeRemotely(this.transport.getMembers(), command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, filter, DeliverOrder.TOTAL, distributed);
            return this.extractResponseValues(responseMap, null);
        }
        CompletableFuture<Map<Address, Response>> remoteFuture = this.transport.invokeRemotelyAsync(null, command, ResponseMode.SYNCHRONOUS, timeout, filter, DeliverOrder.NONE, false);
        this.gcr.wireDependencies(command);
        try {
            if (trace) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            localResponse = (Response)command.invoke();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        return this.extractResponseValues(CompletableFutures.await(remoteFuture), localResponse);
    }

    private int getGlobalTimeout() {
        return (int)this.globalConfiguration.transport().distributedSyncTimeout();
    }

    private void executeOnClusterAsync(ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed) {
        if (!totalOrder) {
            this.asyncTransportExecutor.submit(() -> {
                try {
                    if (trace) {
                        log.tracef("Attempting to execute command on self: %s", command);
                    }
                    this.gcr.wireDependencies(command);
                    command.invoke();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        try {
            DeliverOrder deliverOrder = totalOrder ? DeliverOrder.TOTAL : DeliverOrder.NONE;
            this.transport.invokeRemotely(null, command, ResponseMode.ASYNCHRONOUS, timeout, null, deliverOrder, distributed);
        }
        catch (Exception e) {
            throw new CacheException("Failed to broadcast asynchronous command: " + command, (Throwable)e);
        }
    }

    @Override
    public void broadcastTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, boolean totalOrder, boolean distributed) {
        log.debugf("Updating cluster-wide current topology for cache %s, topology = %s, availability mode = %s", cacheName, cacheTopology, (Object)availabilityMode);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.CH_UPDATE, this.transport.getAddress(), cacheTopology, availabilityMode, this.viewId);
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    @Override
    public void broadcastStableTopologyUpdate(String cacheName, CacheTopology cacheTopology, boolean totalOrder, boolean distributed) {
        log.debugf("Updating cluster-wide stable topology for cache %s, topology = %s", cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.STABLE_TOPOLOGY_UPDATE, this.transport.getAddress(), cacheTopology, null, this.viewId);
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), totalOrder, distributed);
    }

    @Override
    public boolean isRebalancingEnabled() {
        return this.globalRebalancingEnabled;
    }

    @Override
    public boolean isRebalancingEnabled(String cacheName) {
        if (cacheName == null) {
            return this.isRebalancingEnabled();
        }
        ClusterCacheStatus s = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        return s != null ? s.isRebalanceEnabled() : this.isRebalancingEnabled();
    }

    @Override
    public void setRebalancingEnabled(String cacheName, boolean enabled) {
        if (cacheName == null) {
            this.setRebalancingEnabled(enabled);
        } else {
            ClusterCacheStatus clusterCacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
            if (clusterCacheStatus != null) {
                clusterCacheStatus.setRebalanceEnabled(enabled);
            }
        }
    }

    @Override
    public void setRebalancingEnabled(boolean enabled) {
        if (enabled) {
            if (!this.globalRebalancingEnabled) {
                LogFactory.CLUSTER.rebalancingEnabled();
            }
        } else if (this.globalRebalancingEnabled) {
            LogFactory.CLUSTER.rebalancingSuspended();
        }
        this.globalRebalancingEnabled = enabled;
        this.cacheStatusMap.values().forEach(ClusterCacheStatus::startQueuedRebalance);
    }

    @Override
    public void forceRebalance(String cacheName) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            cacheStatus.forceRebalance();
        }
    }

    @Override
    public void forceAvailabilityMode(String cacheName, AvailabilityMode availabilityMode) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            cacheStatus.forceAvailabilityMode(availabilityMode);
        }
    }

    @Override
    public RebalancingStatus getRebalancingStatus(String cacheName) {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus != null) {
            return cacheStatus.getRebalancingStatus();
        }
        return RebalancingStatus.PENDING;
    }

    @Override
    public void broadcastShutdownCache(String cacheName, CacheTopology cacheTopology, boolean totalOrder, boolean distributed) throws Exception {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.SHUTDOWN_PERFORM, this.transport.getAddress(), cacheTopology, null, this.viewId);
        this.executeOnClusterSync(command, this.getGlobalTimeout(), totalOrder, distributed, null);
    }

    @Override
    public void setInitialCacheTopologyId(String cacheName, int topologyId) {
        Configuration configuration = this.cacheManager.getCacheConfiguration(cacheName);
        ClusterCacheStatus cacheStatus = this.initCacheStatusIfAbsent(cacheName, configuration.clustering().cacheMode());
        cacheStatus.setInitialTopologyId(topologyId);
    }

    @Override
    public void handleShutdownRequest(String cacheName) throws Exception {
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        cacheStatus.shutdownCache();
    }

    private Map<Address, Object> extractResponseValues(Map<Address, Response> remoteResponses, Response localResponse) {
        HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
        for (Map.Entry<Address, Response> entry : remoteResponses.entrySet()) {
            ClusterTopologyManagerImpl.addResponseValue(entry.getKey(), entry.getValue(), responseValues);
        }
        if (localResponse != null) {
            ClusterTopologyManagerImpl.addResponseValue(this.transport.getAddress(), localResponse, responseValues);
        }
        return responseValues;
    }

    private static void addResponseValue(Address origin, Response response, Map<Address, Object> values) {
        if (response == CacheNotFoundResponse.INSTANCE) {
            return;
        }
        if (!response.isSuccessful()) {
            Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
            throw new CacheException(String.format("Unsuccessful response received from node '%s': %s", origin, response), (Throwable)cause);
        }
        values.put(origin, ((SuccessfulResponse)response).getResponseValue());
    }

    private static void logNodeJoined(EventLogger logger2, List<Address> newMembers, List<Address> oldMembers) {
        newMembers.stream().filter(address -> !oldMembers.contains(address)).forEach(address -> logger2.info(EventLogCategory.CLUSTER, Messages.MESSAGES.nodeJoined((Address)address)));
    }

    private static void logNodeLeft(EventLogger logger2, List<Address> newMembers, List<Address> oldMembers) {
        oldMembers.stream().filter(address -> !newMembers.contains(address)).forEach(address -> logger2.info(EventLogCategory.CLUSTER, Messages.MESSAGES.nodeLeft((Address)address)));
    }

    public static boolean scatteredLostDataCheck(ConsistentHash stableCH, List<Address> newMembers) {
        HashSet<Address> lostMembers = new HashSet<Address>(stableCH.getMembers());
        lostMembers.removeAll(newMembers);
        log.debugf("Stable CH members: %s, actual members: %s, lost members: %s", stableCH.getMembers(), newMembers, lostMembers);
        return lostMembers.size() > 1;
    }

    public static boolean distLostDataCheck(ConsistentHash stableCH, List<Address> newMembers) {
        for (int i = 0; i < stableCH.getNumSegments(); ++i) {
            if (InfinispanCollections.containsAny(newMembers, stableCH.locateOwnersForSegment(i))) continue;
            return true;
        }
        return false;
    }

    @Listener(sync=true)
    public class ClusterViewListener {
        @Merged
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            ClusterTopologyManagerImpl.this.viewHandlingExecutor.execute(() -> ClusterTopologyManagerImpl.this.handleClusterView(e.isMergeView(), e.getViewId()));
            EventLogger eventLogger = ClusterTopologyManagerImpl.this.eventLogManager.getEventLogger().scope(e.getLocalAddress());
            ClusterTopologyManagerImpl.logNodeJoined(eventLogger, e.getNewMembers(), e.getOldMembers());
            ClusterTopologyManagerImpl.logNodeLeft(eventLogger, e.getNewMembers(), e.getOldMembers());
        }
    }

    private static class CacheTopologyFilterReuser
    implements ResponseFilter {
        Map<CacheTopology, CacheTopology> seenTopologies = new HashMap<CacheTopology, CacheTopology>();
        Map<CacheJoinInfo, CacheJoinInfo> seenInfos = new HashMap<CacheJoinInfo, CacheJoinInfo>();

        private CacheTopologyFilterReuser() {
        }

        @Override
        public boolean isAcceptable(Response response, Address sender) {
            if (response.isSuccessful()) {
                ManagerStatusResponse value = (ManagerStatusResponse)((SuccessfulResponse)response).getResponseValue();
                for (Map.Entry<String, CacheStatusResponse> entry : value.getCaches().entrySet()) {
                    CacheJoinInfo info;
                    CacheJoinInfo replaceInfo;
                    CacheTopology replaceStableTopology;
                    CacheStatusResponse csr = entry.getValue();
                    CacheTopology cacheTopology = csr.getCacheTopology();
                    CacheTopology stableTopology = csr.getStableTopology();
                    CacheTopology replaceCacheTopology = this.seenTopologies.get(cacheTopology);
                    if (replaceCacheTopology == null) {
                        this.seenTopologies.put(cacheTopology, cacheTopology);
                        replaceCacheTopology = cacheTopology;
                    }
                    if (!Objects.equals(cacheTopology, stableTopology)) {
                        replaceStableTopology = this.seenTopologies.get(stableTopology);
                        if (replaceStableTopology == null) {
                            this.seenTopologies.put(stableTopology, stableTopology);
                            replaceStableTopology = stableTopology;
                        }
                    } else {
                        replaceStableTopology = replaceCacheTopology;
                    }
                    if ((replaceInfo = this.seenInfos.get(info = csr.getCacheJoinInfo())) == null) {
                        this.seenInfos.put(info, info);
                    }
                    if (replaceCacheTopology == null && replaceStableTopology == null && replaceInfo == null) continue;
                    entry.setValue(new CacheStatusResponse(replaceInfo != null ? replaceInfo : info, replaceCacheTopology, replaceStableTopology, csr.getAvailabilityMode()));
                }
            }
            return true;
        }

        @Override
        public boolean needMoreResponses() {
            return true;
        }
    }

    private static enum ClusterManagerStatus {
        INITIALIZING,
        REGULAR_MEMBER,
        COORDINATOR,
        RECOVERING_CLUSTER,
        STOPPING;


        boolean isRunning() {
            return this != STOPPING;
        }

        boolean isCoordinator() {
            return this == COORDINATOR || this == RECOVERING_CLUSTER;
        }
    }
}

