/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.BatchStatus;
import org.jberet.runtime.JobExecutionImpl;

public class Main {
    public static void main(String[] args) throws BatchRuntimeException {
        if (args.length == 0) {
            Main.usage(args);
            return;
        }
        String jobXml = args[0];
        if (jobXml == null || jobXml.isEmpty()) {
            Main.usage(args);
            return;
        }
        Properties jobParameters = new Properties();
        for (int i = 1; i < args.length; ++i) {
            int equalSignPos = args[i].indexOf(61);
            if (equalSignPos <= 0) {
                Main.usage(args);
                return;
            }
            String key = args[i].substring(0, equalSignPos).trim();
            String val = args[i].substring(equalSignPos + 1).trim();
            jobParameters.setProperty(key, val);
        }
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        try {
            long jobExecutionId = jobOperator.start(jobXml, jobParameters);
            JobExecutionImpl jobExecution = (JobExecutionImpl)jobOperator.getJobExecution(jobExecutionId);
            jobExecution.awaitTermination(0L, TimeUnit.SECONDS);
            if (!jobExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
                throw new BatchRuntimeException(String.format("The job did not complete: %s%n", jobXml));
            }
        }
        catch (InterruptedException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    private static void usage(String[] args) {
        System.err.printf("Usage: java -classpath ... -Dkey1=val1 ... org.jberet.se.Main jobXML%nThe following application args are invalid:%n%s", Arrays.asList(args));
    }
}

