/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.assignment.AbstractAssignmentTest;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.Assert;
import org.kie.api.task.model.Task;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTotalCompletionTimeTest
extends AbstractAssignmentTest {
    protected PoolingDataSourceWrapper pds;
    protected EntityManagerFactory emf;
    protected Long[] taskIds;
    protected static final String DARTH_VADER = "Darth Vader";
    protected static final String BOBBA_FET = "Bobba Fet";
    protected static final String LUKE_CAGE = "Luke Cage";
    protected static final String TONY_STARK = "Tony Stark";
    protected static final String ADMIN = "Administrator";
    protected static final String DEPLOYMENT_ID = "org.jbpm:jbpm-human-task:7.1.0";
    protected static final String PROCESS_ID = "testing tasks";
    protected static final Map<String, Object> data = new HashMap<String, Object>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractTotalCompletionTimeTest.class);

    protected long createTaskWithoutAssert(TaskFluent tf) {
        Task task = tf.getTask();
        this.taskService.addTask(task, data);
        return task.getId();
    }

    protected long createAndAssertTask(TaskFluent tf, String expectedOwner) {
        Task task = tf.getTask();
        this.taskService.addTask(task, data);
        long taskId = task.getId();
        Assert.assertEquals((String)"Owner mismatch", (Object)expectedOwner, (Object)this.taskService.getTaskById(taskId).getTaskData().getActualOwner().getId());
        return taskId;
    }

    protected void completeTask(long taskId, long delay) {
        Task task = this.taskService.getTaskById(taskId);
        String owner = task.getTaskData().getActualOwner().getId();
        logger.debug("Starting task {} with user {}", (Object)taskId, (Object)owner);
        this.taskService.start(taskId, owner);
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.taskService.complete(taskId, owner, data);
    }
}

