/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment;

import javax.persistence.Persistence;
import org.assertj.core.util.Arrays;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.assignment.AbstractTotalCompletionTimeTest;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.assignment.impl.strategy.LoadBalanceAssignmentStrategy;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalCompletionTimeAssignmentStrategyTest
extends AbstractTotalCompletionTimeTest {
    private static final Logger logger = LoggerFactory.getLogger(TotalCompletionTimeAssignmentStrategyTest.class);

    private void forceBAMEntries() {
        int waitTime;
        long taskId;
        int count;
        for (count = 0; count < 10; ++count) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setAdminUser("Administrator").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks");
            taskId = this.createTaskWithoutAssert(task1);
            waitTime = 100;
            if (count % 3 == 0) {
                waitTime = 230;
            } else if (count % 2 == 0) {
                waitTime = 180;
            }
            this.completeTask(taskId, waitTime);
        }
        for (count = 0; count < 10; ++count) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setAdminUser("Administrator").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks");
            taskId = this.createTaskWithoutAssert(task2);
            waitTime = 1000;
            if (count % 3 == 0) {
                waitTime = 2300;
            } else if (count % 2 == 0) {
                waitTime = 1800;
            }
            this.completeTask(taskId, waitTime);
        }
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.jbpm.task.assignment.enabled", "true");
        System.setProperty("org.jbpm.task.assignment.strategy", "LoadBalance");
        System.setProperty("org.jbpm.task.assignment.loadbalance.calculator", "org.jbpm.services.task.assignment.impl.TotalCompletionTimeLoadCalculator");
        System.setProperty("org.jbpm.services.task.assignment.taskduration.timetolive", "1000");
        this.pds = TotalCompletionTimeAssignmentStrategyTest.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        AssignmentServiceProvider.override((AssignmentStrategy)new LoadBalanceAssignmentStrategy());
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).getTaskService();
        this.taskIds = new Long[100];
        this.forceBAMEntries();
    }

    @After
    public void clean() throws Exception {
        System.clearProperty("org.jbpm.task.assignment.enabled");
        System.clearProperty("org.jbpm.task.assignment.strategy");
        System.clearProperty("org.jbpm.task.assignment.loadbalance.calculator");
        AssignmentServiceProvider.clear();
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    @Test
    public void testMultipleUser() {
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{"Bobba Fet", "Darth Vader", "Luke Cage"});
        for (int x = 0; x < 6; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x % 3]);
        }
        this.completeTask(this.taskIds[1], 500L);
        TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
        this.createAndAssertTask(task2, "Darth Vader");
        logger.info("testMultipleUser completed");
    }

    @Test
    public void testMultipleUserWithGroup() {
        int x;
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{"Bobba Fet", "Luke Cage", "Tony Stark"});
        for (x = 0; x < 3; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser("Bobba Fet").addPotentialGroup("Crusaders").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1000L);
        expectedOwners = (String[])Arrays.array((Object[])new String[]{"Luke Cage", "Bobba Fet", "Tony Stark"});
        for (x = 3; x < 6; ++x) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser("Bobba Fet").addPotentialGroup("Crusaders").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task2, expectedOwners[x - 3]);
        }
        logger.info("testMultipleUserWithGroup completed");
    }

    @Test
    public void testMultipleUserWithAdd() {
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{"Bobba Fet", "Darth Vader", "Luke Cage", "Tony Stark"});
        for (int x = 0; x < 3; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1000L);
        TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
        this.createAndAssertTask(task2, "Darth Vader");
        TaskFluent task3 = new TaskFluent().setName("MultiUserLoadBalanceTask3").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").addPotentialUser("Tony Stark").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
        this.createAndAssertTask(task3, "Tony Stark");
        logger.info("testMultipleUserWithAdd completed");
    }

    @Test
    public void testMultipleUsersWithRemove() {
        int x;
        String[] expectedOwners = (String[])Arrays.array((Object[])new String[]{"Bobba Fet", "Darth Vader", "Luke Cage", "Tony Stark"});
        for (x = 0; x < 4; ++x) {
            TaskFluent task1 = new TaskFluent().setName("MultiUserLoadBalanceTask1").addPotentialUser("Bobba Fet").addPotentialUser("Darth Vader").addPotentialUser("Luke Cage").addPotentialUser("Tony Stark").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task1, expectedOwners[x]);
        }
        this.completeTask(this.taskIds[1], 1500L);
        expectedOwners = (String[])Arrays.array((Object[])new String[]{"Bobba Fet", "Luke Cage", "Tony Stark"});
        for (x = 4; x < 7; ++x) {
            TaskFluent task2 = new TaskFluent().setName("MultiUserLoadBalanceTask2").addPotentialUser("Bobba Fet").addPotentialUser("Luke Cage").addPotentialUser("Tony Stark").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.taskIds[x] = this.createAndAssertTask(task2, expectedOwners[x - 4]);
        }
        logger.info("testMultipleUsersWithRemove completed");
    }
}

