/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment;

import java.util.Collections;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.assignment.AbstractTotalCompletionTimeTest;
import org.jbpm.services.task.assignment.UserTaskLoad;
import org.jbpm.services.task.assignment.impl.TotalCompletionTimeLoadCalculator;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.persistence.JPATaskPersistenceContext;
import org.jbpm.services.task.utils.TaskFluent;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskPersistenceContext;

public class TotalCompletionTimeLoadCalculatorTest
extends AbstractTotalCompletionTimeTest {
    private void forceBAMEntries() {
        for (int count = 0; count < 4; ++count) {
            TaskFluent task1 = new TaskFluent().setName("CalculatorTask1").addPotentialUser("Darth Vader").setAdminUser("Administrator").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks");
            long taskId = this.createTaskWithoutAssert(task1);
            int waitTime = 100;
            if (count % 2 == 0) {
                waitTime = 180;
            }
            this.completeTask(taskId, waitTime);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.pds = TotalCompletionTimeLoadCalculatorTest.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).getTaskService();
        this.taskIds = new Long[100];
        this.forceBAMEntries();
    }

    @After
    public void clean() throws Exception {
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    @Test
    public void testGetUserTaskLoad() {
        for (int x = 0; x < 6; ++x) {
            TaskFluent task = new TaskFluent().setName("CalculatorTask1").addPotentialUser("Darth Vader").setDeploymentID("org.jbpm:jbpm-human-task:7.1.0").setProcessId("testing tasks").setAdminUser("Administrator");
            this.createTaskWithoutAssert(task);
        }
        UserImpl userVader = new UserImpl("Darth Vader");
        TaskContext ctx = new TaskContext();
        EntityManager em = this.emf.createEntityManager();
        ctx.setPersistenceContext((TaskPersistenceContext)new JPATaskPersistenceContext(em));
        TotalCompletionTimeLoadCalculator calculator = new TotalCompletionTimeLoadCalculator();
        Double userTaskLoad = calculator.getUserTaskLoad((User)userVader, (org.kie.api.task.TaskContext)ctx).getCalculatedLoad();
        Double userTaskLoads = ((UserTaskLoad)calculator.getUserTaskLoads(Collections.singletonList(userVader), (org.kie.api.task.TaskContext)ctx).iterator().next()).getCalculatedLoad();
        Assertions.assertThat((Double)userTaskLoad).isGreaterThanOrEqualTo(840.0);
        Assertions.assertThat((Double)userTaskLoads).isEqualTo((Object)userTaskLoad);
        em.close();
    }
}

