/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.utils.TaskFluent;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.query.AuditTaskDeleteBuilder;
import org.kie.internal.task.query.AuditTaskQueryBuilder;

public class AuditTaskDeleteTest
extends TaskJPAAuditService {
    private static HashMap<String, Object> context;
    private static EntityManagerFactory emf;
    private Task[] taskTestData;
    private static Random random;

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }

    @Before
    public void setUp() throws Exception {
        context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.services.task", (String)"jdbc/jbpm-ds");
        emf = (EntityManagerFactory)context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
        this.produceTaskInstances();
    }

    @After
    public void cleanup() {
        PersistenceUtil.cleanUp(context);
    }

    private Calendar randomCal() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.roll(6, -1 * random.nextInt(3650));
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal;
    }

    private void produceTaskInstances() {
        InternalTaskService taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(emf).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).listener((TaskLifeCycleEventListener)new BAMTaskEventListener(true)).getTaskService();
        Calendar cal = this.randomCal();
        String processId = "process";
        this.taskTestData = new Task[10];
        ArrayList<ProcessInstanceLog> pLogs = new ArrayList<ProcessInstanceLog>();
        for (int i = 0; i < 10; ++i) {
            cal.add(11, 1);
            Task task = new TaskFluent().setName("This is my task name").addPotentialGroup("Knights Templer").setAdminUser("Administrator").setProcessId(processId + i).setProcessInstanceId((long)i).setCreatedOn(cal.getTime()).getTask();
            taskService.addTask(task, new HashMap());
            this.taskTestData[i] = task;
            ProcessInstanceLog plog = this.buildCompletedProcessInstance(i);
            pLogs.add(plog);
        }
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        Object tx = jtaHelper.joinTransaction(em);
        pLogs.forEach(pl -> em.persist(pl));
        jtaHelper.leaveTransaction(em, tx);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByProcessId() {
        int p = 0;
        String processId = this.taskTestData[p++].getTaskData().getProcessId();
        String processId2 = this.taskTestData[p++].getTaskData().getProcessId();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)this.auditTaskDelete().processId(new String[]{processId, processId2});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByDate() {
        int p = 0;
        Date endDate = this.taskTestData[p++].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)this.auditTaskDelete().date(new Date[]{endDate});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByProcessIdAndDate() {
        int p = 0;
        String processId = this.taskTestData[p].getTaskData().getProcessId();
        Date endDate = this.taskTestData[p].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)this.auditTaskDelete().date(new Date[]{endDate})).processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByProcessIdAndNotMatchingDate() {
        int p = 0;
        String processId = this.taskTestData[p++].getTaskData().getProcessId();
        Date endDate = this.taskTestData[p++].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)this.auditTaskDelete().date(new Date[]{endDate})).processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByDateRangeEnd() {
        Date endDate = this.taskTestData[4].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)this.auditTaskDelete().dateRangeEnd(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByDateRangeStart() {
        Date endDate = this.taskTestData[8].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)this.auditTaskDelete().dateRangeStart(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteAuditTaskInfoLogByDateRange() {
        Date startDate = this.taskTestData[4].getTaskData().getCreatedOn();
        Date endDate = this.taskTestData[8].getTaskData().getCreatedOn();
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)this.auditTaskDelete().dateRangeStart(startDate)).dateRangeEnd(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testTaskAuditServiceClear() {
        AuditTaskQueryBuilder queryBuilder = this.auditTaskQuery();
        List tasks = ((AuditTaskQueryBuilder)queryBuilder.taskId(new long[]{this.taskTestData[4].getId()})).build().getResultList();
        Assert.assertEquals((long)1L, (long)tasks.size());
        queryBuilder.clear();
        List data = this.auditTaskQuery().build().getResultList();
        Assert.assertEquals((long)10L, (long)data.size());
        this.clear();
        data = this.auditTaskQuery().build().getResultList();
        Assert.assertEquals((long)0L, (long)data.size());
    }

    @Test
    public void testDeleteAuditTaskInfoLogByTimestamp() {
        List tasks = ((AuditTaskQueryBuilder)this.auditTaskQuery().taskId(new long[]{this.taskTestData[4].getId()})).build().getResultList();
        Assert.assertEquals((long)1L, (long)tasks.size());
        AuditTaskDeleteBuilder updateBuilder = (AuditTaskDeleteBuilder)this.auditTaskDelete().date(new Date[]{((AuditTask)tasks.get(0)).getCreatedOn()});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    private ProcessInstanceLog buildCompletedProcessInstance(long processInstanceId) {
        ProcessInstanceLog pil = new ProcessInstanceLog(processInstanceId, "test");
        pil.setDuration(Long.valueOf(0L));
        pil.setExternalId("none");
        pil.setIdentity("none");
        pil.setOutcome("");
        pil.setParentProcessInstanceId(-1L);
        pil.setProcessId("test");
        pil.setProcessName("test process");
        pil.setProcessVersion("1");
        pil.setStatus(2);
        pil.setStart(null);
        pil.setEnd(null);
        return pil;
    }

    static {
        random = new Random();
    }
}

