/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.security.KeyPair;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.SAML2NameIDPolicyBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.w3c.dom.Document;

public class InitiateLogin
implements AuthChallenge {
    protected static Logger log = Logger.getLogger(InitiateLogin.class);
    protected SamlDeployment deployment;
    protected SamlSessionStore sessionStore;

    public InitiateLogin(SamlDeployment deployment, SamlSessionStore sessionStore) {
        this.deployment = deployment;
        this.sessionStore = sessionStore;
    }

    public boolean errorPage() {
        return false;
    }

    public int getResponseCode() {
        return 0;
    }

    public boolean challenge(HttpFacade httpFacade) {
        try {
            String actionUrl;
            String issuerURL = this.deployment.getEntityID();
            String destinationUrl = actionUrl = this.deployment.getIDP().getSingleSignOnService().getRequestBindingUrl();
            String nameIDPolicyFormat = this.deployment.getNameIDPolicyFormat();
            if (nameIDPolicyFormat == null) {
                nameIDPolicyFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
            }
            SAML2AuthnRequestBuilder authnRequestBuilder = new SAML2AuthnRequestBuilder().destination(destinationUrl).issuer(issuerURL).forceAuthn(this.deployment.isForceAuthentication()).nameIdPolicy(SAML2NameIDPolicyBuilder.format((String)nameIDPolicyFormat));
            if (this.deployment.getIDP().getSingleSignOnService().getResponseBinding() != null) {
                String protocolBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
                if (this.deployment.getIDP().getSingleSignOnService().getResponseBinding() == SamlDeployment.Binding.POST) {
                    protocolBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
                }
                authnRequestBuilder.protocolBinding(protocolBinding);
            }
            if (this.deployment.getAssertionConsumerServiceUrl() != null) {
                authnRequestBuilder.assertionConsumerUrl(this.deployment.getAssertionConsumerServiceUrl());
            }
            BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
            if (this.deployment.getIDP().getSingleSignOnService().signRequest()) {
                KeyPair keypair = this.deployment.getSigningKeyPair();
                if (keypair == null) {
                    throw new RuntimeException("Signing keys not configured");
                }
                if (this.deployment.getSignatureCanonicalizationMethod() != null) {
                    binding.canonicalizationMethod(this.deployment.getSignatureCanonicalizationMethod());
                }
                binding.signWith(keypair);
                binding.signDocument();
            }
            this.sessionStore.saveRequest();
            Document document = authnRequestBuilder.toDocument();
            SamlDeployment.Binding samlBinding = this.deployment.getIDP().getSingleSignOnService().getRequestBinding();
            SamlUtil.sendSaml(true, httpFacade, actionUrl, binding, document, samlBinding);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create authentication request.", e);
        }
        return true;
    }
}

