/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.IOException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SamlUtil {
    protected static Logger log = Logger.getLogger(SamlUtil.class);

    public static void sendSaml(boolean asRequest, HttpFacade httpFacade, String actionUrl, BaseSAML2BindingBuilder binding, Document document, SamlDeployment.Binding samlBinding) throws ProcessingException, ConfigurationException, IOException {
        if (samlBinding == SamlDeployment.Binding.POST) {
            String html = asRequest ? binding.postBinding(document).getHtmlRequest(actionUrl) : binding.postBinding(document).getHtmlResponse(actionUrl);
            httpFacade.getResponse().setStatus(200);
            httpFacade.getResponse().setHeader("Content-Type", "text/html");
            httpFacade.getResponse().setHeader("Pragma", "no-cache");
            httpFacade.getResponse().setHeader("Cache-Control", "no-cache, no-store");
            httpFacade.getResponse().getOutputStream().write(html.getBytes(GeneralConstants.SAML_CHARSET));
            httpFacade.getResponse().end();
        } else {
            String uri = asRequest ? binding.redirectBinding(document).requestURI(actionUrl).toString() : binding.redirectBinding(document).responseURI(actionUrl).toString();
            httpFacade.getResponse().setStatus(302);
            httpFacade.getResponse().setHeader("Location", uri);
            httpFacade.getResponse().end();
        }
    }

    public static String getRedirectTo(HttpFacade facade, String contextPath, String baseUri) {
        int index;
        String redirectTo = facade.getRequest().getQueryParamValue("redirectTo");
        if (redirectTo != null && !redirectTo.isEmpty()) {
            return SamlUtil.buildRedirectTo(baseUri, redirectTo);
        }
        redirectTo = facade.getRequest().getFirstParam("RelayState");
        if (redirectTo != null && (index = redirectTo.indexOf("redirectTo=")) >= 0) {
            String to = redirectTo.substring(index + "redirectTo=".length());
            if ((index = to.indexOf(59)) >= 0) {
                to = to.substring(0, index);
            }
            return SamlUtil.buildRedirectTo(baseUri, to);
        }
        if (contextPath.isEmpty()) {
            baseUri = baseUri + "/";
        }
        return baseUri;
    }

    private static String buildRedirectTo(String baseUri, String redirectTo) {
        if (redirectTo.startsWith("/")) {
            redirectTo = redirectTo.substring(1);
        }
        if (baseUri.endsWith("/")) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        redirectTo = baseUri + "/" + redirectTo;
        return redirectTo;
    }

    public static SamlSession validateSamlSession(Object potentialSamlSession, SamlDeployment deployment) {
        if (potentialSamlSession == null) {
            log.debug((Object)"SamlSession was not found in the session");
            return null;
        }
        if (!(potentialSamlSession instanceof SamlSession)) {
            log.debug((Object)"Provided samlSession was not SamlSession type");
            return null;
        }
        SamlSession samlSession = (SamlSession)potentialSamlSession;
        XMLGregorianCalendar sessionNotOnOrAfter = samlSession.getSessionNotOnOrAfter();
        if (sessionNotOnOrAfter != null) {
            XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
            XMLTimeUtil.add((XMLGregorianCalendar)sessionNotOnOrAfter, (long)deployment.getIDP().getAllowedClockSkew());
            if (now.compare(sessionNotOnOrAfter) != -1) {
                return null;
            }
        }
        return samlSession;
    }
}

