/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.adapters.saml.config.Key;
import org.keycloak.adapters.saml.config.parsers.AbstractKeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.HasQName;

public class KeyStoreParser
extends AbstractKeycloakSamlAdapterV1Parser<Key.KeyStoreConfig> {
    private static final KeyStoreParser INSTANCE = new KeyStoreParser();

    private KeyStoreParser() {
        super(KeycloakSamlAdapterV1QNames.KEY_STORE);
    }

    public static KeyStoreParser getInstance() {
        return INSTANCE;
    }

    protected Key.KeyStoreConfig instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        Key.KeyStoreConfig keyStore = new Key.KeyStoreConfig();
        keyStore.setType(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_TYPE));
        keyStore.setAlias(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ALIAS));
        keyStore.setFile(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_FILE));
        keyStore.setResource(StaxParserUtil.getAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_RESOURCE));
        keyStore.setPassword(StaxParserUtil.getRequiredAttributeValueRP((StartElement)element, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_PASSWORD));
        if (keyStore.getFile() == null && keyStore.getResource() == null) {
            throw new ParsingException("KeyStore element must have the url or classpath attribute set");
        }
        return keyStore;
    }

    protected void processSubElement(XMLEventReader xmlEventReader, Key.KeyStoreConfig target, KeycloakSamlAdapterV1QNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case CERTIFICATE: {
                target.setCertificateAlias(StaxParserUtil.getRequiredAttributeValueRP((StartElement)elementDetail, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ALIAS));
                break;
            }
            case PRIVATE_KEY: {
                target.setPrivateKeyAlias(StaxParserUtil.getRequiredAttributeValueRP((StartElement)elementDetail, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_ALIAS));
                target.setPrivateKeyPassword(StaxParserUtil.getRequiredAttributeValueRP((StartElement)elementDetail, (HasQName)KeycloakSamlAdapterV1QNames.ATTR_PASSWORD));
            }
        }
    }
}

