/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jbossweb.infinispan;

import org.infinispan.Cache;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;

public class SsoCacheSessionIdMapperUpdater
implements SessionIdMapperUpdater {
    private final SessionIdMapperUpdater delegate;
    private final Cache<String, String[]> httpSessionToSsoCache;

    public SsoCacheSessionIdMapperUpdater(Cache<String, String[]> httpSessionToSsoCache, SessionIdMapperUpdater previousIdMapperUpdater) {
        this.delegate = previousIdMapperUpdater;
        this.httpSessionToSsoCache = httpSessionToSsoCache;
    }

    public void clear(SessionIdMapper idMapper) {
        this.httpSessionToSsoCache.clear();
        this.delegate.clear(idMapper);
    }

    public boolean refreshMapping(SessionIdMapper idMapper, String httpSessionId) {
        String[] ssoAndPrincipal = (String[])this.httpSessionToSsoCache.get((Object)httpSessionId);
        if (ssoAndPrincipal != null) {
            this.delegate.map(idMapper, ssoAndPrincipal[0], ssoAndPrincipal[1], httpSessionId);
            return true;
        }
        return false;
    }

    public void map(SessionIdMapper idMapper, String sso, String principal, String httpSessionId) {
        this.httpSessionToSsoCache.put((Object)httpSessionId, (Object)new String[]{sso, principal});
        this.delegate.map(idMapper, sso, principal, httpSessionId);
    }

    public void removeSession(SessionIdMapper idMapper, String httpSessionId) {
        this.httpSessionToSsoCache.remove((Object)httpSessionId);
        this.delegate.removeSession(idMapper, httpSessionId);
    }
}

