/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.security.cert.X509Certificate;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.LogoutError;

public interface HttpFacade {
    public Request getRequest();

    public Response getResponse();

    public X509Certificate[] getCertificateChain();

    public static class Cookie {
        protected String name;
        protected String value;
        protected int version;
        protected String domain;
        protected String path;

        public Cookie(String name, String value, int version, String domain, String path) {
            this.name = name;
            this.value = value;
            this.version = version;
            this.domain = domain;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getVersion() {
            return this.version;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static interface Response {
        public void setStatus(int var1);

        public void addHeader(String var1, String var2);

        public void setHeader(String var1, String var2);

        public void resetCookie(String var1, String var2);

        public void setCookie(String var1, String var2, String var3, String var4, int var5, boolean var6, boolean var7);

        public OutputStream getOutputStream();

        public void sendError(int var1);

        public void sendError(int var1, String var2);

        public void end();
    }

    public static interface Request {
        public String getMethod();

        public String getURI();

        public boolean isSecure();

        public String getFirstParam(String var1);

        public String getQueryParamValue(String var1);

        public Cookie getCookie(String var1);

        public String getHeader(String var1);

        public List<String> getHeaders(String var1);

        public InputStream getInputStream();

        public String getRemoteAddr();

        public void setError(AuthenticationError var1);

        public void setError(LogoutError var1);
    }
}

