/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jetty;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.jboss.logging.Logger;
import org.keycloak.adapters.jetty.spi.JettyHttpFacade;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlConfigResolver;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.saml.jetty.JettySamlSessionStore;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.webbrowsersso.BrowserHandler;
import org.keycloak.adapters.saml.profile.webbrowsersso.SamlEndpoint;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.saml.common.exceptions.ParsingException;

public abstract class AbstractSamlAuthenticator
extends LoginAuthenticator {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    protected static final Logger log = Logger.getLogger(AbstractSamlAuthenticator.class);
    protected SamlDeploymentContext deploymentContext;
    protected SamlConfigResolver configResolver;
    protected String errorPage;
    protected SessionIdMapper idMapper = new InMemorySessionIdMapper();

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.saml.xml.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    public JettySamlSessionStore getTokenStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        JettySamlSessionStore store = (JettySamlSessionStore)request.getAttribute(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = this.createJettySamlSessionStore(request, facade, resolvedDeployment);
        request.setAttribute(TOKEN_STORE_NOTE, (Object)store);
        return store;
    }

    protected JettySamlSessionStore createJettySamlSessionStore(Request request, HttpFacade facade, SamlDeployment resolvedDeployment) {
        JettySamlSessionStore store = new JettySamlSessionStore(request, this.createSessionTokenStore(request, resolvedDeployment), facade, this.idMapper, this.createSessionManagement(request), resolvedDeployment);
        return store;
    }

    public abstract AdapterSessionStore createSessionTokenStore(Request var1, SamlDeployment var2);

    public abstract JettyUserSessionManagement createSessionManagement(Request var1);

    public void logoutCurrent(Request request) {
        JettyHttpFacade facade = new JettyHttpFacade(request, null);
        SamlDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        JettySamlSessionStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
        tokenStore.logoutAccount();
    }

    protected void forwardToLogoutPage(Request request, HttpServletResponse response, SamlDeployment deployment) {
        RequestDispatcher disp = request.getRequestDispatcher(deployment.getLogoutPage());
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        try {
            disp.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this.initializeKeycloak();
        this._loginService = new DummyLoginService();
        String error = configuration.getInitParameter("org.eclipse.jetty.security.form_error_page");
        this.setErrorPage(error);
    }

    private void setErrorPage(String path) {
        if (path != null && path.trim().length() != 0) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.errorPage = path;
            if (this.errorPage.indexOf(63) > 0) {
                this.errorPage = this.errorPage.substring(0, this.errorPage.indexOf(63));
            }
        }
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public SamlConfigResolver getConfigResolver() {
        return this.configResolver;
    }

    public void setConfigResolver(SamlConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public void initializeKeycloak() {
        InputStream configInputStream;
        String configResolverClass;
        Object theServletContext = null;
        ContextHandler.Context currentContext = ContextHandler.getCurrentContext();
        if (currentContext != null) {
            String contextPath = currentContext.getContextPath();
            theServletContext = "".equals(contextPath) ? currentContext : currentContext.getContext(contextPath);
        }
        if (this.configResolver == null && theServletContext != null && (configResolverClass = theServletContext.getInitParameter("keycloak.config.resolver")) != null) {
            try {
                this.configResolver = (SamlConfigResolver)ContextHandler.getCurrentContext().getClassLoader().loadClass(configResolverClass).newInstance();
                log.infov("Using {0} to resolve Keycloak configuration on a per-request basis.", (Object)configResolverClass);
            }
            catch (Exception ex) {
                log.infov("The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
            }
        }
        if (this.configResolver == null && theServletContext != null && (configInputStream = this.getConfigInputStream((ServletContext)theServletContext)) != null) {
            ContextHandler.Context servletContext = theServletContext;
            SamlDeployment deployment = null;
            try {
                deployment = new DeploymentBuilder().build(configInputStream, new ResourceLoader((ServletContext)servletContext){
                    final /* synthetic */ ServletContext val$servletContext;
                    {
                        this.val$servletContext = servletContext;
                    }

                    public InputStream getResourceAsStream(String resource) {
                        return this.val$servletContext.getResourceAsStream(resource);
                    }
                });
            }
            catch (ParsingException e) {
                throw new RuntimeException(e);
            }
            this.deploymentContext = new SamlDeploymentContext(deployment);
        }
        if (theServletContext != null) {
            theServletContext.setAttribute(SamlDeploymentContext.class.getName(), (Object)this.deploymentContext);
        }
    }

    private InputStream getConfigInputStream(ServletContext servletContext) {
        InputStream is = AbstractSamlAuthenticator.getJSONFromServletContext(servletContext);
        if (is == null) {
            String path = servletContext.getInitParameter("keycloak.config.file");
            if (path == null) {
                is = servletContext.getResourceAsStream("/WEB-INF/keycloak-saml.xml");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        Request request;
        JettyHttpFacade facade;
        SamlDeployment deployment;
        if (log.isTraceEnabled()) {
            log.trace((Object)"*** authenticate");
        }
        if ((deployment = this.deploymentContext.resolveDeployment((HttpFacade)(facade = new JettyHttpFacade(request = this.resolveRequest(req), (HttpServletResponse)res)))) == null || !deployment.isConfigured()) {
            log.debug((Object)"*** deployment isn't configured return false");
            return Authentication.UNAUTHENTICATED;
        }
        boolean isEndpoint = request.getRequestURI().substring(request.getContextPath().length()).endsWith("/saml");
        if (!mandatory && !isEndpoint) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        JettySamlSessionStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
        SamlAuthenticator authenticator = null;
        authenticator = isEndpoint ? new SamlAuthenticator((HttpFacade)facade, deployment, tokenStore){

            protected void completeAuthentication(SamlSession account) {
            }

            protected SamlAuthenticationHandler createBrowserHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
                return new SamlEndpoint(facade, deployment, sessionStore);
            }
        } : new SamlAuthenticator((HttpFacade)facade, deployment, tokenStore){

            protected void completeAuthentication(SamlSession account) {
            }

            protected SamlAuthenticationHandler createBrowserHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
                return new BrowserHandler(facade, deployment, sessionStore);
            }
        };
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (facade.isEnded()) {
                return Authentication.SEND_SUCCESS;
            }
            SamlSession samlSession = tokenStore.getAccount();
            Authentication authentication = this.register(request, samlSession);
            return authentication;
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            this.logoutCurrent(request);
            if (deployment.getLogoutPage() != null) {
                this.forwardToLogoutPage(request, (HttpServletResponse)res, deployment);
            }
            return Authentication.SEND_CONTINUE;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return Authentication.SEND_CONTINUE;
    }

    protected abstract Request resolveRequest(ServletRequest var1);

    public String getAuthMethod() {
        return "KEYCLOAK-SAML";
    }

    public static UserIdentity createIdentity(SamlSession samlSession) {
        HashSet roles = samlSession.getRoles();
        if (roles == null) {
            roles = new HashSet();
        }
        Subject theSubject = new Subject();
        String[] theRoles = new String[roles.size()];
        roles.toArray(theRoles);
        return new DefaultUserIdentity(theSubject, (Principal)samlSession.getPrincipal(), theRoles);
    }

    public Authentication register(Request request, SamlSession samlSession) {
        Authentication authentication = request.getAuthentication();
        if (!(authentication instanceof KeycloakAuthentication)) {
            UserIdentity userIdentity = AbstractSamlAuthenticator.createIdentity(samlSession);
            authentication = this.createAuthentication(userIdentity, request);
            request.setAuthentication(authentication);
        }
        return authentication;
    }

    public abstract Authentication createAuthentication(UserIdentity var1, Request var2);

    public static abstract class KeycloakAuthentication
    extends UserAuthentication {
        public KeycloakAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }
    }

    private class DummyLoginService
    implements LoginService {
        private DummyLoginService() {
        }

        public String getName() {
            return null;
        }

        public UserIdentity login(String username, Object credentials) {
            return null;
        }

        public boolean validate(UserIdentity user) {
            return false;
        }

        public IdentityService getIdentityService() {
            return null;
        }

        public void setIdentityService(IdentityService service) {
        }

        public void logout(UserIdentity user) {
        }
    }
}

