/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.SystemPropertiesUtil;
import org.keycloak.saml.processing.core.saml.v2.util.SecurityActions;

public class XMLTimeUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final ThreadLocal<DatatypeFactory> DATATYPE_FACTORY = new ThreadLocal<DatatypeFactory>(){

        @Override
        protected DatatypeFactory initialValue() {
            try {
                return XMLTimeUtil.newDatatypeFactory();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static XMLGregorianCalendar add(XMLGregorianCalendar value, long milis) {
        XMLGregorianCalendar newVal = (XMLGregorianCalendar)value.clone();
        Duration duration = DATATYPE_FACTORY.get().newDuration(milis);
        newVal.add(duration);
        return newVal;
    }

    public static XMLGregorianCalendar subtract(XMLGregorianCalendar value, long milis) {
        if (milis < 0L) {
            throw logger.invalidArgumentError("milis should be a positive value");
        }
        return XMLTimeUtil.add(value, -1L * milis);
    }

    public static XMLGregorianCalendar getIssueInstant(String timezone) {
        TimeZone tz = TimeZone.getTimeZone(timezone);
        DatatypeFactory dtf = DATATYPE_FACTORY.get();
        GregorianCalendar gc = new GregorianCalendar(tz);
        XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(gc);
        return xgc;
    }

    public static XMLGregorianCalendar getIssueInstant() throws ConfigurationException {
        return XMLTimeUtil.getIssueInstant(XMLTimeUtil.getCurrentTimeZoneID());
    }

    public static String getCurrentTimeZoneID() {
        String timezonePropertyValue = SecurityActions.getSystemProperty("picketlink.timezone", "GMT");
        TimeZone timezone = "TIMEZONE_DEFAULT".equals(timezonePropertyValue) ? TimeZone.getDefault() : TimeZone.getTimeZone(timezonePropertyValue);
        return timezone.getID();
    }

    public static long inMilis(int valueInMins) {
        return valueInMins * 60 * 1000;
    }

    public static boolean isValid(XMLGregorianCalendar now, XMLGregorianCalendar notbefore, XMLGregorianCalendar notOnOrAfter) {
        int val = 0;
        if (notbefore != null && ((val = notbefore.compare(now)) == 2 || val == 1)) {
            return false;
        }
        return notOnOrAfter == null || (val = notOnOrAfter.compare(now)) == 1;
    }

    public static Duration parseAsDuration(String timeValue) throws ParsingException {
        if (timeValue == null) {
            PicketLinkLoggerFactory.getLogger().nullArgumentError("duration time");
        }
        DatatypeFactory factory = DATATYPE_FACTORY.get();
        try {
            if (timeValue.startsWith("P")) {
                return factory.newDuration(timeValue);
            }
            return factory.newDuration(Long.valueOf(timeValue));
        }
        catch (Exception e) {
            throw logger.samlMetaDataFailedToCreateCacheDuration(timeValue);
        }
    }

    public static XMLGregorianCalendar parse(String timeString) throws ParsingException {
        DatatypeFactory factory = DATATYPE_FACTORY.get();
        return factory.newXMLGregorianCalendar(timeString);
    }

    private static DatatypeFactory newDatatypeFactory() throws DatatypeConfigurationException {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(XMLTimeUtil.class.getClassLoader());
            }
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            return datatypeFactory;
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
    }
}

