/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.saml.v2.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SecurityActions;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLRequestWriter;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;
import org.keycloak.saml.processing.core.util.JAXPValidationUtil;
import org.w3c.dom.Document;

public class SAML2Request {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private SAMLDocumentHolder samlDocumentHolder = null;
    private String nameIDFormat = JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get();

    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }

    public AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws ConfigurationException {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        AuthnRequestType authnRequest = new AuthnRequestType(id, issueInstant);
        authnRequest.setAssertionConsumerServiceURL(URI.create(assertionConsumerURL));
        authnRequest.setProtocolBinding(URI.create(JBossSAMLConstants.HTTP_POST_BINDING.get()));
        if (destination != null) {
            authnRequest.setDestination(URI.create(destination));
        }
        NameIDType issuer = new NameIDType();
        issuer.setValue(issuerValue);
        authnRequest.setIssuer(issuer);
        NameIDPolicyType nameIDPolicy = new NameIDPolicyType();
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        nameIDPolicy.setFormat(URI.create(this.nameIDFormat));
        authnRequest.setNameIDPolicy(nameIDPolicy);
        return authnRequest;
    }

    public AuthnRequestType getAuthnRequestType(String fileName) throws ConfigurationException, ProcessingException, ParsingException {
        if (fileName == null) {
            throw logger.nullArgumentError("fileName");
        }
        URL resourceURL = SecurityActions.loadResource(this.getClass(), fileName);
        if (resourceURL == null) {
            throw logger.resourceNotFound(fileName);
        }
        InputStream is = null;
        try {
            is = resourceURL.openStream();
        }
        catch (IOException e) {
            throw logger.processingError(e);
        }
        return this.getAuthnRequestType(is);
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ConfigurationException, ParsingException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        SAML2Object requestType = (SAML2Object)samlParser.parse(samlDocument);
        this.samlDocumentHolder = new SAMLDocumentHolder(requestType, samlDocument);
        return requestType;
    }

    public RequestAbstractType getRequestType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        RequestAbstractType requestType = (RequestAbstractType)samlParser.parse(samlDocument);
        this.samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)requestType, samlDocument);
        return requestType;
    }

    public AuthnRequestType getAuthnRequestType(InputStream is) throws ConfigurationException, ProcessingException, ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        AuthnRequestType requestType = (AuthnRequestType)samlParser.parse(samlDocument);
        this.samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)requestType, samlDocument);
        return requestType;
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public static LogoutRequestType createLogoutRequest(String issuer) throws ConfigurationException {
        LogoutRequestType lrt = new LogoutRequestType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
        NameIDType issuerNameID = new NameIDType();
        issuerNameID.setValue(issuer);
        lrt.setIssuer(issuerNameID);
        return lrt;
    }

    public static Document convert(RequestAbstractType rat) throws ProcessingException, ConfigurationException, ParsingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SAMLRequestWriter writer = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(bos));
        if (rat instanceof AuthnRequestType) {
            writer.write((AuthnRequestType)rat);
        } else if (rat instanceof LogoutRequestType) {
            writer.write((LogoutRequestType)rat);
        }
        return DocumentUtil.getDocument(new String(bos.toByteArray(), GeneralConstants.SAML_CHARSET));
    }

    public static Document convert(ResponseType responseType) throws ProcessingException, ParsingException, ConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAMLResponseWriter writer = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(baos));
        writer.write(responseType);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return DocumentUtil.getDocument(bis);
    }

    public static void marshall(RequestAbstractType requestType, OutputStream os) throws ProcessingException {
        SAMLRequestWriter samlRequestWriter = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(os));
        if (requestType instanceof AuthnRequestType) {
            samlRequestWriter.write((AuthnRequestType)requestType);
        } else if (requestType instanceof LogoutRequestType) {
            samlRequestWriter.write((LogoutRequestType)requestType);
        } else {
            throw logger.unsupportedType(requestType.getClass().getName());
        }
    }

    public static void marshall(RequestAbstractType requestType, Writer writer) throws ProcessingException {
        SAMLRequestWriter samlRequestWriter = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(writer));
        if (requestType instanceof AuthnRequestType) {
            samlRequestWriter.write((AuthnRequestType)requestType);
        } else if (requestType instanceof LogoutRequestType) {
            samlRequestWriter.write((LogoutRequestType)requestType);
        } else {
            throw logger.unsupportedType(requestType.getClass().getName());
        }
    }
}

