/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ContactTypeType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.LocalizedURIType;
import org.keycloak.dom.saml.v2.metadata.OrganizationType;
import org.keycloak.dom.saml.v2.metadata.RequestedAttributeType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.dom.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.AbstractDescriptorParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLEntityDescriptorParser
extends AbstractDescriptorParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String EDT = JBossSAMLConstants.ENTITY_DESCRIPTOR.get();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute cacheDuration;
        Attribute id;
        xmlEventReader = this.filterWhiteSpaceCharacters(xmlEventReader);
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.EDT);
        Attribute entityID = startElement.getAttributeByName(new QName(JBossSAMLConstants.ENTITY_ID.get()));
        String entityIDValue = StaxParserUtil.getAttributeValue(entityID);
        EntityDescriptorType entityDescriptorType = new EntityDescriptorType(entityIDValue);
        Attribute validUntil = startElement.getAttributeByName(new QName(JBossSAMLConstants.VALID_UNTIL.get()));
        if (validUntil != null) {
            String validUntilValue = StaxParserUtil.getAttributeValue(validUntil);
            entityDescriptorType.setValidUntil(XMLTimeUtil.parse(validUntilValue));
        }
        if ((id = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()))) != null) {
            entityDescriptorType.setID(StaxParserUtil.getAttributeValue(id));
        }
        if ((cacheDuration = startElement.getAttributeByName(new QName(JBossSAMLConstants.CACHE_DURATION.get()))) != null) {
            entityDescriptorType.setCacheDuration(XMLTimeUtil.parseAsDuration(StaxParserUtil.getAttributeValue(cacheDuration)));
        }
        while (xmlEventReader.hasNext()) {
            EntityDescriptorType.EDTChoiceType edtChoice;
            EntityDescriptorType.EDTDescriptorChoiceType edtDescChoice;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                StaxParserUtil.validate((EndElement)xmlEvent, this.EDT);
                StaxParserUtil.getNextEndElement(xmlEventReader);
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.IDP_SSO_DESCRIPTOR.get().equals(localPart)) {
                IDPSSODescriptorType idpSSO = this.parseIDPSSODescriptor(xmlEventReader);
                edtDescChoice = new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)idpSSO);
                edtChoice = EntityDescriptorType.EDTChoiceType.oneValue((EntityDescriptorType.EDTDescriptorChoiceType)edtDescChoice);
                entityDescriptorType.addChoiceType(edtChoice);
                continue;
            }
            if (JBossSAMLConstants.SP_SSO_DESCRIPTOR.get().equals(localPart)) {
                SPSSODescriptorType spSSO = this.parseSPSSODescriptor(xmlEventReader);
                edtDescChoice = new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spSSO);
                edtChoice = EntityDescriptorType.EDTChoiceType.oneValue((EntityDescriptorType.EDTDescriptorChoiceType)edtDescChoice);
                entityDescriptorType.addChoiceType(edtChoice);
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE_AUTHORITY_DESCRIPTOR.get().equals(localPart)) {
                AttributeAuthorityDescriptorType attrAuthority = this.parseAttributeAuthorityDescriptor(xmlEventReader);
                edtDescChoice = new EntityDescriptorType.EDTDescriptorChoiceType(attrAuthority);
                edtChoice = EntityDescriptorType.EDTChoiceType.oneValue((EntityDescriptorType.EDTDescriptorChoiceType)edtDescChoice);
                entityDescriptorType.addChoiceType(edtChoice);
                continue;
            }
            if (JBossSAMLConstants.AUTHN_AUTHORITY_DESCRIPTOR.get().equals(localPart)) {
                throw logger.unsupportedType("AuthnAuthorityDescriptor");
            }
            if (JBossSAMLConstants.AFFILIATION_DESCRIPTOR.get().equals(localPart)) {
                throw logger.unsupportedType(" AffiliationDescriptor");
            }
            if (JBossSAMLConstants.PDP_DESCRIPTOR.get().equals(localPart)) {
                throw logger.unsupportedType(" PDPDescriptor");
            }
            if (localPart.equals(JBossSAMLConstants.SIGNATURE.get())) {
                entityDescriptorType.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ORGANIZATION.get().equals(localPart)) {
                OrganizationType organization = this.parseOrganization(xmlEventReader);
                entityDescriptorType.setOrganization(organization);
                continue;
            }
            if (JBossSAMLConstants.CONTACT_PERSON.get().equals(localPart)) {
                entityDescriptorType.addContactPerson(this.parseContactPerson(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ADDITIONAL_METADATA_LOCATION.get().equals(localPart)) {
                throw logger.unsupportedType("AdditionalMetadataLocation");
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                entityDescriptorType.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ROLE_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                RoleDescriptorType roleDescriptor = this.parseRoleDescriptor(xmlEventReader);
                edtDescChoice = new EntityDescriptorType.EDTDescriptorChoiceType(roleDescriptor);
                edtChoice = EntityDescriptorType.EDTChoiceType.oneValue((EntityDescriptorType.EDTDescriptorChoiceType)edtDescChoice);
                entityDescriptorType.addChoiceType(edtChoice);
                continue;
            }
            throw logger.parserUnknownStartElement(localPart, startElement.getLocation());
        }
        return entityDescriptorType;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.ENTITY_DESCRIPTOR.get());
    }

    private SPSSODescriptorType parseSPSSODescriptor(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute wantAuthnSigned;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.SP_SSO_DESCRIPTOR.get());
        List<String> protocolEnum = SAMLParserUtil.parseProtocolEnumeration(startElement);
        SPSSODescriptorType spSSODescriptor = new SPSSODescriptorType(protocolEnum);
        Attribute wantAssertionsSigned = startElement.getAttributeByName(new QName(JBossSAMLConstants.WANT_ASSERTIONS_SIGNED.get()));
        if (wantAssertionsSigned != null) {
            spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(wantAssertionsSigned))));
        }
        if ((wantAuthnSigned = startElement.getAttributeByName(new QName(JBossSAMLConstants.AUTHN_REQUESTS_SIGNED.get()))) != null) {
            spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(wantAuthnSigned))));
        }
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            IndexedEndpointType endpoint;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.SP_SSO_DESCRIPTOR.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ARTIFACT_RESOLUTION_SERVICE.get().equals(localPart)) {
                endpoint = this.parseArtifactResolutionService(xmlEventReader, startElement);
                spSSODescriptor.addArtifactResolutionService(endpoint);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE.get().equals(localPart)) {
                endpoint = this.parseAssertionConsumerService(xmlEventReader, startElement);
                spSSODescriptor.addAssertionConsumerService(endpoint);
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE.get().equals(localPart)) {
                AttributeConsumingServiceType attributeConsumer = this.parseAttributeConsumingService(xmlEventReader, startElement);
                spSSODescriptor.addAttributeConsumerService(attributeConsumer);
                continue;
            }
            if (JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get());
                spSSODescriptor.addSingleLogoutService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.MANAGE_NAMEID_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.MANAGE_NAMEID_SERVICE.get());
                spSSODescriptor.addManageNameIDService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.NAMEID_FORMAT.get().equalsIgnoreCase(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                spSSODescriptor.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.KEY_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                spSSODescriptor.addKeyDescriptor(this.parseKeyDescriptor(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                spSSODescriptor.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return spSSODescriptor;
    }

    private IDPSSODescriptorType parseIDPSSODescriptor(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.IDP_SSO_DESCRIPTOR.get());
        List<String> protocolEnum = SAMLParserUtil.parseProtocolEnumeration(startElement);
        IDPSSODescriptorType idpSSODescriptor = new IDPSSODescriptorType(protocolEnum);
        Attribute wantAuthnSigned = startElement.getAttributeByName(new QName(JBossSAMLConstants.WANT_AUTHN_REQUESTS_SIGNED.get()));
        if (wantAuthnSigned != null) {
            idpSSODescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(wantAuthnSigned))));
        }
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            IndexedEndpointType endpoint;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.IDP_SSO_DESCRIPTOR.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ARTIFACT_RESOLUTION_SERVICE.get().equals(localPart)) {
                endpoint = this.parseArtifactResolutionService(xmlEventReader, startElement);
                idpSSODescriptor.addArtifactResolutionService(endpoint);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION_ID_REQUEST_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.ASSERTION_ID_REQUEST_SERVICE.get());
                idpSSODescriptor.addAssertionIDRequestService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.SINGLE_LOGOUT_SERVICE.get());
                idpSSODescriptor.addSingleLogoutService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.SINGLE_SIGNON_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.SINGLE_SIGNON_SERVICE.get());
                idpSSODescriptor.addSingleSignOnService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.MANAGE_NAMEID_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.MANAGE_NAMEID_SERVICE.get());
                idpSSODescriptor.addManageNameIDService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.NAMEID_MAPPING_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                endpoint = this.getEndpointType(startElement);
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.NAMEID_MAPPING_SERVICE.get());
                idpSSODescriptor.addNameIDMappingService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.NAMEID_FORMAT.get().equalsIgnoreCase(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                idpSSODescriptor.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE.get().equalsIgnoreCase(localPart)) {
                AttributeType attribute = SAMLParserUtil.parseAttribute(xmlEventReader);
                idpSSODescriptor.addAttribute(attribute);
                continue;
            }
            if (JBossSAMLConstants.KEY_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                idpSSODescriptor.addKeyDescriptor(this.parseKeyDescriptor(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                idpSSODescriptor.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return idpSSODescriptor;
    }

    private EndpointType getEndpointType(StartElement startElement) {
        Attribute bindingAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.BINDING.get()));
        String binding = StaxParserUtil.getAttributeValue(bindingAttr);
        Attribute locationAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.LOCATION.get()));
        String location = StaxParserUtil.getAttributeValue(locationAttr);
        IndexedEndpointType endpoint = new IndexedEndpointType(URI.create(binding), URI.create(location));
        Attribute responseLocation = startElement.getAttributeByName(new QName(JBossSAMLConstants.RESPONSE_LOCATION.get()));
        if (responseLocation != null) {
            endpoint.setResponseLocation(URI.create(StaxParserUtil.getAttributeValue(responseLocation)));
        }
        return endpoint;
    }

    private AttributeAuthorityDescriptorType parseAttributeAuthorityDescriptor(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE_AUTHORITY_DESCRIPTOR.get());
        List<String> protocolEnum = SAMLParserUtil.parseProtocolEnumeration(startElement);
        AttributeAuthorityDescriptorType attributeAuthority = new AttributeAuthorityDescriptorType(protocolEnum);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.ATTRIBUTE_AUTHORITY_DESCRIPTOR.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE_SERVICE.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                Attribute bindingAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.BINDING.get()));
                String binding = StaxParserUtil.getAttributeValue(bindingAttr);
                Attribute locationAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.LOCATION.get()));
                String location = StaxParserUtil.getAttributeValue(locationAttr);
                IndexedEndpointType endpoint = new IndexedEndpointType(URI.create(binding), URI.create(location));
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.ATTRIBUTE_SERVICE.get());
                attributeAuthority.addAttributeService((EndpointType)endpoint);
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE_PROFILE.get().equalsIgnoreCase(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                attributeAuthority.addAttributeProfile(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.KEY_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                attributeAuthority.addKeyDescriptor(this.parseKeyDescriptor(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.NAMEID_FORMAT.get().equalsIgnoreCase(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                attributeAuthority.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                attributeAuthority.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return attributeAuthority;
    }

    private OrganizationType parseOrganization(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ORGANIZATION.get());
        OrganizationType org = new OrganizationType();
        while (xmlEventReader.hasNext()) {
            LocalizedNameType localName;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.ORGANIZATION.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ORGANIZATION_NAME.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                localName = this.getLocalizedName(xmlEventReader, startElement);
                org.addOrganizationName(localName);
                continue;
            }
            if (JBossSAMLConstants.ORGANIZATION_DISPLAY_NAME.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                localName = this.getLocalizedName(xmlEventReader, startElement);
                org.addOrganizationDisplayName(localName);
                continue;
            }
            if (JBossSAMLConstants.ORGANIZATION_URL.get().equals(localPart) || JBossSAMLConstants.ORGANIZATION_URL_ALT.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                Attribute lang = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XML.get(), "lang"));
                String langVal = StaxParserUtil.getAttributeValue(lang);
                LocalizedURIType localName2 = new LocalizedURIType(langVal);
                localName2.setValue(URI.create(StaxParserUtil.getElementText(xmlEventReader)));
                org.addOrganizationURL(localName2);
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                org.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return org;
    }

    private KeyDescriptorType parseKeyDescriptor(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.KEY_DESCRIPTOR.get());
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        String use = StaxParserUtil.getAttributeValue(startElement, "use");
        if (use != null && !use.isEmpty()) {
            keyDescriptor.setUse(KeyTypes.fromValue((String)use));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.KEY_DESCRIPTOR.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.KEY_INFO.get().equals(localPart)) {
                Element key = StaxParserUtil.getDOMElement(xmlEventReader);
                keyDescriptor.setKeyInfo(key);
                continue;
            }
            if (JBossSAMLConstants.ENCRYPTION_METHOD.get().equals(localPart)) {
                keyDescriptor.addEncryptionMethod(this.parseEncryptionMethod(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return keyDescriptor;
    }

    private EncryptionMethodType parseEncryptionMethod(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ENCRYPTION_METHOD.get());
        Attribute algorithm = startElement.getAttributeByName(new QName("Algorithm"));
        EncryptionMethodType encryptionMethodType = new EncryptionMethodType(algorithm.getValue());
        BigInteger keySize = null;
        byte[] OAEPparams = null;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.ENCRYPTION_METHOD.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if ("KeySize".equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                keySize = BigInteger.valueOf(Long.valueOf(StaxParserUtil.getElementText(xmlEventReader)));
                continue;
            }
            if ("OAEPparams".equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                OAEPparams = StaxParserUtil.getElementText(xmlEventReader).getBytes(GeneralConstants.SAML_CHARSET);
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        EncryptionMethodType.EncryptionMethod encryptionMethod = new EncryptionMethodType.EncryptionMethod(keySize, OAEPparams);
        encryptionMethodType.setEncryptionMethod(encryptionMethod);
        return encryptionMethodType;
    }

    private ContactType parseContactPerson(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.CONTACT_PERSON.get());
        Attribute attr = startElement.getAttributeByName(new QName(JBossSAMLConstants.CONTACT_TYPE.get()));
        if (attr == null) {
            throw logger.parserRequiredAttribute("contactType");
        }
        ContactType contactType = new ContactType(ContactTypeType.fromValue((String)StaxParserUtil.getAttributeValue(attr)));
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.CONTACT_PERSON.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.COMPANY.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                contactType.setCompany(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.GIVEN_NAME.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                contactType.setGivenName(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.SURNAME.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                contactType.setSurName(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EMAIL_ADDRESS.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                contactType.addEmailAddress(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.TELEPHONE_NUMBER.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                contactType.addTelephone(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                contactType.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return contactType;
    }

    private LocalizedNameType getLocalizedName(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        Attribute lang = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XML.get(), "lang"));
        String langVal = StaxParserUtil.getAttributeValue(lang);
        LocalizedNameType localName = new LocalizedNameType(langVal);
        localName.setValue(StaxParserUtil.getElementText(xmlEventReader));
        return localName;
    }

    private IndexedEndpointType parseAssertionConsumerService(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        IndexedEndpointType endpoint = this.parseIndexedEndpoint(xmlEventReader, startElement);
        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
        StaxParserUtil.validate(endElement, JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE.get());
        return endpoint;
    }

    private IndexedEndpointType parseArtifactResolutionService(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        IndexedEndpointType endpoint = this.parseIndexedEndpoint(xmlEventReader, startElement);
        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
        StaxParserUtil.validate(endElement, JBossSAMLConstants.ARTIFACT_RESOLUTION_SERVICE.get());
        return endpoint;
    }

    private IndexedEndpointType parseIndexedEndpoint(XMLEventReader xmlEventReader, StartElement startElement) {
        Attribute index;
        Attribute bindingAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.BINDING.get()));
        String binding = StaxParserUtil.getAttributeValue(bindingAttr);
        Attribute locationAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.LOCATION.get()));
        String location = StaxParserUtil.getAttributeValue(locationAttr);
        IndexedEndpointType endpoint = new IndexedEndpointType(URI.create(binding), URI.create(location));
        Attribute isDefault = startElement.getAttributeByName(new QName(JBossSAMLConstants.ISDEFAULT.get()));
        if (isDefault != null) {
            endpoint.setIsDefault(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(isDefault))));
        }
        if ((index = startElement.getAttributeByName(new QName(JBossSAMLConstants.INDEX.get()))) != null) {
            endpoint.setIndex(Integer.parseInt(StaxParserUtil.getAttributeValue(index)));
        }
        return endpoint;
    }

    private AttributeConsumingServiceType parseAttributeConsumingService(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        Attribute indexAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.INDEX.get()));
        if (indexAttr == null) {
            throw logger.parserRequiredAttribute("index");
        }
        AttributeConsumingServiceType attributeConsumer = new AttributeConsumingServiceType(Integer.parseInt(StaxParserUtil.getAttributeValue(indexAttr)));
        while (xmlEventReader.hasNext()) {
            LocalizedNameType localName;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.SERVICE_NAME.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                localName = this.getLocalizedName(xmlEventReader, startElement);
                attributeConsumer.addServiceName(localName);
                continue;
            }
            if (JBossSAMLConstants.SERVICE_DESCRIPTION.get().equals(localPart)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                localName = this.getLocalizedName(xmlEventReader, startElement);
                attributeConsumer.addServiceDescription(localName);
                continue;
            }
            if (JBossSAMLConstants.REQUESTED_ATTRIBUTE.get().equals(localPart)) {
                RequestedAttributeType attType = this.parseRequestedAttributeType(xmlEventReader, startElement);
                attributeConsumer.addRequestedAttribute(attType);
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return attributeConsumer;
    }

    private RequestedAttributeType parseRequestedAttributeType(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.REQUESTED_ATTRIBUTE.get());
        RequestedAttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()));
        if (name == null) {
            throw logger.parserRequiredAttribute("Name");
        }
        attributeType = new RequestedAttributeType(StaxParserUtil.getAttributeValue(name));
        Attribute isRequired = startElement.getAttributeByName(new QName(JBossSAMLConstants.IS_REQUIRED.get()));
        if (isRequired != null) {
            attributeType.setIsRequired(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(isRequired))));
        }
        SAMLParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.REQUESTED_ATTRIBUTE.get(), (AttributeType)attributeType);
        return attributeType;
    }

    private ExtensionsType parseExtensions(XMLEventReader xmlEventReader) throws ParsingException {
        ExtensionsType extensions = new ExtensionsType();
        Element extElement = StaxParserUtil.getDOMElement(xmlEventReader);
        extensions.setElement(extElement);
        return extensions;
    }

    private RoleDescriptorType parseRoleDescriptor(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ROLE_DESCRIPTOR.get());
        List<String> protocolEnum = SAMLParserUtil.parseProtocolEnumeration(startElement);
        RoleDescriptorType roleDescriptorType = new RoleDescriptorType(protocolEnum){};
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement end = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(end, JBossSAMLConstants.ROLE_DESCRIPTOR.get());
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.KEY_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                KeyDescriptorType keyDescriptor = this.parseKeyDescriptor(xmlEventReader);
                roleDescriptorType.addKeyDescriptor(keyDescriptor);
                continue;
            }
            StaxParserUtil.bypassElementBlock(xmlEventReader, localPart);
        }
        return roleDescriptorType;
    }
}

