/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.writers;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.assertion.AdviceType;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextClassRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.OneTimeUseType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.assertion.URIType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.BaseWriter;
import org.w3c.dom.Element;

public class SAMLAssertionWriter
extends BaseWriter {
    public SAMLAssertionWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AssertionType assertion) throws ProcessingException {
        this.write(assertion, false);
    }

    public void write(AssertionType assertion, boolean forceWriteDsigNamespace) throws ProcessingException {
        AdviceType advice;
        ConditionsType conditions;
        SubjectType subject;
        Element sig = assertion.getSignature();
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ASSERTION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        if (forceWriteDsigNamespace && sig != null && sig.getPrefix() != null && !sig.hasAttribute("xmlns:" + sig.getPrefix())) {
            StaxUtil.writeNameSpace(this.writer, sig.getPrefix(), "http://www.w3.org/2000/09/xmldsig#");
        }
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), assertion.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), assertion.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), assertion.getIssueInstant().toString());
        NameIDType issuer = assertion.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if (sig != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((subject = assertion.getSubject()) != null) {
            this.write(subject);
        }
        if ((conditions = assertion.getConditions()) != null) {
            List typeOfConditions;
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.CONDITIONS.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
            if (conditions.getNotBefore() != null) {
                StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_BEFORE.get(), conditions.getNotBefore().toString());
            }
            if (conditions.getNotOnOrAfter() != null) {
                StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_ON_OR_AFTER.get(), conditions.getNotOnOrAfter().toString());
            }
            if ((typeOfConditions = conditions.getConditions()) != null) {
                for (ConditionAbstractType typeCondition : typeOfConditions) {
                    if (typeCondition instanceof AudienceRestrictionType) {
                        AudienceRestrictionType art = (AudienceRestrictionType)typeCondition;
                        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUDIENCE_RESTRICTION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                        List audiences = art.getAudience();
                        if (audiences != null) {
                            for (URI audience : audiences) {
                                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUDIENCE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                                StaxUtil.writeCharacters(this.writer, audience.toString());
                                StaxUtil.writeEndElement(this.writer);
                            }
                        }
                        StaxUtil.writeEndElement(this.writer);
                    }
                    if (!(typeCondition instanceof OneTimeUseType)) continue;
                    StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ONE_TIME_USE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    StaxUtil.writeEndElement(this.writer);
                }
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if ((advice = assertion.getAdvice()) != null) {
            throw logger.notImplementedYet("Advice");
        }
        Set statements = assertion.getStatements();
        if (statements != null) {
            for (StatementAbstractType statement : statements) {
                if (statement instanceof AuthnStatementType) {
                    this.write((AuthnStatementType)statement, false);
                    continue;
                }
                if (statement instanceof AttributeStatementType) {
                    this.write((AttributeStatementType)statement);
                    continue;
                }
                throw logger.writerUnknownTypeError(statement.getClass().getName());
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatementAbstractType statement) throws ProcessingException {
        throw logger.notImplementedYet("NYI");
    }

    public void write(AttributeStatementType statement) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        List attributes = statement.getAttributes();
        if (attributes != null) {
            for (AttributeStatementType.ASTChoiceType attr : attributes) {
                EncryptedElementType encType;
                AttributeType attributeType = attr.getAttribute();
                if (attributeType != null) {
                    this.write(attributeType);
                }
                if ((encType = attr.getEncryptedAssertion()) == null) continue;
                throw logger.notImplementedYet("EncryptedElementType");
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AuthnStatementType authnStatement, boolean includeNamespace) throws ProcessingException {
        AuthnContextType authnContext;
        String sessionIndex;
        XMLGregorianCalendar authnInstant;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_STATEMENT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        if (includeNamespace) {
            StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
            StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        }
        if ((authnInstant = authnStatement.getAuthnInstant()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.AUTHN_INSTANT.get(), authnInstant.toString());
        }
        if ((sessionIndex = authnStatement.getSessionIndex()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.SESSION_INDEX.get(), sessionIndex);
        }
        if ((authnContext = authnStatement.getAuthnContext()) != null) {
            this.write(authnContext);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AuthnContextType authContext) throws ProcessingException {
        Set authAuthorities;
        URIType uriType;
        Iterator iterator;
        Object uriTypes;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        AuthnContextType.AuthnContextTypeSequence sequence = authContext.getSequence();
        if (sequence != null) {
            AuthnContextClassRefType authnContextClassRefType = sequence.getClassRef();
            if (authnContextClassRefType != null) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, authnContextClassRefType.getValue().toASCIIString());
                StaxUtil.writeEndElement(this.writer);
            }
            if ((uriTypes = sequence.getURIType()) != null) {
                iterator = uriTypes.iterator();
                while (iterator.hasNext()) {
                    uriType = (URIType)iterator.next();
                    if (uriType instanceof AuthnContextDeclType) {
                        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                        StaxUtil.writeCharacters(this.writer, uriType.getValue().toASCIIString());
                        StaxUtil.writeEndElement(this.writer);
                    }
                    if (!(uriType instanceof AuthnContextDeclRefType)) continue;
                    StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    StaxUtil.writeCharacters(this.writer, uriType.getValue().toASCIIString());
                    StaxUtil.writeEndElement(this.writer);
                }
            }
        }
        if ((authAuthorities = authContext.getAuthenticatingAuthority()) != null) {
            for (URI aa : authAuthorities) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHENTICATING_AUTHORITY.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, aa.toASCIIString());
                StaxUtil.writeEndElement(this.writer);
            }
        }
        uriTypes = authContext.getURIType();
        iterator = uriTypes.iterator();
        while (iterator.hasNext()) {
            uriType = (URIType)iterator.next();
            if (uriType instanceof AuthnContextClassRefType) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
                StaxUtil.writeEndElement(this.writer);
                continue;
            }
            if (uriType instanceof AuthnContextDeclRefType) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
                StaxUtil.writeEndElement(this.writer);
                continue;
            }
            if (!(uriType instanceof AuthnContextDeclType)) continue;
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
            StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

