/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import java.io.StringWriter;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;

public class SAMLAttributeValueParser
implements StaxParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final SAMLAttributeValueParser INSTANCE = new SAMLAttributeValueParser();
    private static final QName NIL = new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "nil", JBossSAMLURIConstants.XSI_PREFIX.get());
    private static final QName XSI_TYPE = new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", JBossSAMLURIConstants.XSI_PREFIX.get());

    public static SAMLAttributeValueParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement element = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(element, SAMLAssertionQNames.ATTRIBUTE_VALUE.getQName());
        Attribute nil = element.getAttributeByName(NIL);
        if (nil != null) {
            String nilValue = StaxParserUtil.getAttributeValue(nil);
            if (nilValue != null && (nilValue.equalsIgnoreCase("true") || nilValue.equals("1"))) {
                String elementText = StaxParserUtil.getElementText(xmlEventReader);
                if (elementText == null || elementText.isEmpty()) {
                    return null;
                }
                throw logger.nullValueError("nil attribute is not in SAML20 format");
            }
            throw logger.parserRequiredAttribute(JBossSAMLURIConstants.XSI_PREFIX.get() + ":nil");
        }
        Attribute type = element.getAttributeByName(XSI_TYPE);
        if (type == null) {
            if (StaxParserUtil.hasTextAhead(xmlEventReader)) {
                return StaxParserUtil.getElementText(xmlEventReader);
            }
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                element = (StartElement)xmlEvent;
                QName qName = element.getName();
                if (Objects.equals(qName, SAMLAssertionQNames.NAMEID.getQName())) {
                    return SAMLParserUtil.parseNameIDType(xmlEventReader);
                }
            } else if (xmlEvent instanceof EndElement) {
                return "";
            }
            return SAMLAttributeValueParser.parseAnyTypeAsString(xmlEventReader);
        }
        String typeValue = StaxParserUtil.getAttributeValue(type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":anyType")) {
            return SAMLAttributeValueParser.parseAnyTypeAsString(xmlEventReader);
        }
        if (typeValue.contains(":base64Binary")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":boolean")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        throw logger.parserUnknownXSI(typeValue);
    }

    public static String parseAnyTypeAsString(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            XMLEvent event = xmlEventReader.peek();
            if (event.isStartElement()) {
                event = xmlEventReader.nextTag();
                StringWriter sw = new StringWriter();
                XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(sw);
                int tagLevel = 1;
                do {
                    writer.add(event);
                    event = (XMLEvent)xmlEventReader.next();
                    if (event.isStartElement()) {
                        ++tagLevel;
                    }
                    if (!event.isEndElement()) continue;
                    --tagLevel;
                } while (xmlEventReader.hasNext() && tagLevel > 0);
                writer.add(event);
                writer.flush();
                return sw.toString();
            }
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        catch (Exception e) {
            throw logger.parserError(e);
        }
    }
}

