/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.adapter.saml.extension.KeyAddHandler;
import org.keycloak.subsystem.adapter.saml.extension.KeyStoreDefinition;
import org.keycloak.subsystem.adapter.saml.extension.KeycloakSamlExtension;

public class KeyDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition SIGNING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signing", ModelType.BOOLEAN, true).setXmlName("signing")).build();
    static final SimpleAttributeDefinition ENCRYPTION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("encryption", ModelType.BOOLEAN, true).setXmlName("encryption")).build();
    static final SimpleAttributeDefinition PRIVATE_KEY_PEM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("private-key-pem", ModelType.STRING, true).setXmlName("PrivateKeyPem")).build();
    static final SimpleAttributeDefinition PUBLIC_KEY_PEM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-key-pem", ModelType.STRING, true).setXmlName("PublicKeyPem")).build();
    static final SimpleAttributeDefinition CERTIFICATE_PEM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-pem", ModelType.STRING, true).setXmlName("CertificatePem")).build();
    static final ObjectTypeAttributeDefinition KEY_STORE = ObjectTypeAttributeDefinition.Builder.of((String)"key-store", (AttributeDefinition[])KeyStoreDefinition.ALL_ATTRIBUTES).setAllowNull(false).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SIGNING, ENCRYPTION};
    static final SimpleAttributeDefinition[] ELEMENTS = new SimpleAttributeDefinition[]{PRIVATE_KEY_PEM, PUBLIC_KEY_PEM, CERTIFICATE_PEM};
    static final AttributeDefinition[] ALL_ATTRIBUTES = new AttributeDefinition[]{SIGNING, ENCRYPTION, PRIVATE_KEY_PEM, PUBLIC_KEY_PEM, CERTIFICATE_PEM, KEY_STORE};
    static final HashMap<String, SimpleAttributeDefinition> ATTRIBUTE_MAP = new HashMap();
    static final HashMap<String, SimpleAttributeDefinition> ELEMENT_MAP;
    static final KeyDefinition INSTANCE;

    private KeyDefinition() {
        super(PathElement.pathElement((String)"key"), (ResourceDescriptionResolver)KeycloakSamlExtension.getResourceDescriptionResolver("key"), (OperationStepHandler)new KeyAddHandler(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ALL_ATTRIBUTES);
        for (AttributeDefinition attribute : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    static SimpleAttributeDefinition lookup(String xmlName) {
        return ATTRIBUTE_MAP.get(xmlName);
    }

    static SimpleAttributeDefinition lookupElement(String xmlName) {
        return ELEMENT_MAP.get(xmlName);
    }

    static {
        for (SimpleAttributeDefinition def : ATTRIBUTES) {
            ATTRIBUTE_MAP.put(def.getXmlName(), def);
        }
        ELEMENT_MAP = new HashMap();
        for (SimpleAttributeDefinition def : ELEMENTS) {
            ELEMENT_MAP.put(def.getXmlName(), def);
        }
        INSTANCE = new KeyDefinition();
    }
}

