/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.Serializable;
import java.util.Objects;

public class COSEAlgorithmIdentifier
implements Serializable {
    public static final COSEAlgorithmIdentifier RS1 = new COSEAlgorithmIdentifier(-65535L);
    public static final COSEAlgorithmIdentifier RS256 = new COSEAlgorithmIdentifier(-257L);
    public static final COSEAlgorithmIdentifier RS384 = new COSEAlgorithmIdentifier(-258L);
    public static final COSEAlgorithmIdentifier RS512 = new COSEAlgorithmIdentifier(-259L);
    public static final COSEAlgorithmIdentifier ES256 = new COSEAlgorithmIdentifier(-7L);
    public static final COSEAlgorithmIdentifier ES384 = new COSEAlgorithmIdentifier(-35L);
    public static final COSEAlgorithmIdentifier ES512 = new COSEAlgorithmIdentifier(-36L);
    private final long value;

    COSEAlgorithmIdentifier(long value) {
        this.value = value;
    }

    public static COSEAlgorithmIdentifier create(long value) {
        return new COSEAlgorithmIdentifier(value);
    }

    @JsonCreator
    private static COSEAlgorithmIdentifier deserialize(long value) throws InvalidFormatException {
        return COSEAlgorithmIdentifier.create(value);
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSEAlgorithmIdentifier that = (COSEAlgorithmIdentifier)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

