/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.x509.X509ClientCertificateLookupFactory;

public abstract class AbstractClientCertificateFromHttpHeadersLookupFactory
implements X509ClientCertificateLookupFactory {
    private static final Logger logger = Logger.getLogger(AbstractClientCertificateFromHttpHeadersLookupFactory.class);
    protected static final String CERTIFICATE_CHAIN_LENGTH = "certificateChainLength";
    protected static final String HTTP_HEADER_CLIENT_CERT = "sslClientCert";
    protected static final String HTTP_HEADER_CERT_CHAIN_PREFIX = "sslCertChainPrefix";
    protected String sslClientCertHttpHeader;
    protected String sslChainHttpHeaderPrefix;
    protected int certificateChainLength = 1;

    public void init(Config.Scope config) {
        if (config != null) {
            this.certificateChainLength = config.getInt(CERTIFICATE_CHAIN_LENGTH, Integer.valueOf(1));
            logger.tracev("{0}: ''{1}''", (Object)CERTIFICATE_CHAIN_LENGTH, (Object)this.certificateChainLength);
            this.sslClientCertHttpHeader = config.get(HTTP_HEADER_CLIENT_CERT, "");
            logger.tracev("{0}:   ''{1}''", (Object)HTTP_HEADER_CLIENT_CERT, (Object)this.sslClientCertHttpHeader);
            this.sslChainHttpHeaderPrefix = config.get(HTTP_HEADER_CERT_CHAIN_PREFIX, null);
            if (this.sslChainHttpHeaderPrefix != null) {
                logger.tracev("{0}:  ''{1}''", (Object)HTTP_HEADER_CERT_CHAIN_PREFIX, (Object)this.sslChainHttpHeaderPrefix);
            } else {
                logger.tracev("{0} was not configured", (Object)HTTP_HEADER_CERT_CHAIN_PREFIX);
            }
        } else {
            logger.tracev("No configuration for ''{0}'' reverse proxy was found", (Object)this.getId());
            this.sslClientCertHttpHeader = "";
            this.sslChainHttpHeaderPrefix = "";
            this.certificateChainLength = 0;
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

