/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;

public class GitHubIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://github.com/login/oauth/authorize";
    public static final String TOKEN_URL = "https://github.com/login/oauth/access_token";
    public static final String PROFILE_URL = "https://api.github.com/user";
    public static final String EMAIL_URL = "https://api.github.com/user/emails";
    public static final String DEFAULT_SCOPE = "user:email";

    public GitHubIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return PROFILE_URL;
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"));
        String username = this.getJsonProperty(profile, "login");
        user.setUsername(username);
        user.setName(this.getJsonProperty(profile, "name"));
        user.setEmail(this.getJsonProperty(profile, "email"));
        user.setIdpConfig(this.getConfig());
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        return user;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.doGet((String)PROFILE_URL, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            BrokeredIdentityContext user = this.extractIdentityFromProfile(null, profile);
            if (user.getEmail() == null) {
                user.setEmail(this.searchEmail(accessToken));
            }
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from github.", (Throwable)e);
        }
    }

    private String searchEmail(String accessToken) {
        try {
            ArrayNode emails = (ArrayNode)SimpleHttp.doGet((String)EMAIL_URL, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            Iterator loop = emails.elements();
            while (loop.hasNext()) {
                JsonNode mail = (JsonNode)loop.next();
                if (!mail.get("primary").asBoolean()) continue;
                return this.getJsonProperty(mail, "email");
            }
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user email from github.", (Throwable)e);
        }
        throw new IdentityBrokerException("Primary email from github is not found.");
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

