/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.GroupCommandDefinition;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCredentialsCmd;
import org.keycloak.client.registration.cli.commands.ConfigInitialTokenCmd;
import org.keycloak.client.registration.cli.commands.ConfigRegistrationTokenCmd;
import org.keycloak.client.registration.cli.commands.ConfigTruststoreCmd;
import org.keycloak.client.registration.cli.util.OsUtil;

@GroupCommandDefinition(name="config", description="COMMAND [ARGUMENTS]", groupCommands={ConfigCredentialsCmd.class})
public class ConfigCmd
extends AbstractAuthOptionsCmd
implements Command {
    @Arguments
    protected List<String> args;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.args != null && this.args.size() > 0) {
                String cmd;
                switch (cmd = this.args.get(0)) {
                    case "credentials": {
                        ConfigCredentialsCmd command = new ConfigCredentialsCmd();
                        command.initFromParent(this);
                        CommandResult commandResult = command.execute(commandInvocation);
                        return commandResult;
                    }
                    case "truststore": {
                        ConfigTruststoreCmd command = new ConfigTruststoreCmd();
                        command.initFromParent(this);
                        CommandResult commandResult = command.execute(commandInvocation);
                        return commandResult;
                    }
                    case "initial-token": {
                        ConfigInitialTokenCmd command = new ConfigInitialTokenCmd();
                        command.initFromParent(this);
                        CommandResult commandResult = command.execute(commandInvocation);
                        return commandResult;
                    }
                    case "registration-token": {
                        ConfigRegistrationTokenCmd command = new ConfigRegistrationTokenCmd();
                        command.initFromParent(this);
                        CommandResult commandResult = command.execute(commandInvocation);
                        return commandResult;
                    }
                }
                if (this.printHelp()) {
                    CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                    return commandResult;
                }
                throw new IllegalArgumentException("Unknown sub-command: " + cmd + this.suggestHelp());
            }
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            throw new IllegalArgumentException("Sub-command required by '" + OsUtil.CMD + " config' - one of: 'credentials', 'truststore', 'initial-token', 'registration-token'");
        }
        finally {
            commandInvocation.stop();
        }
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help config' for more information";
    }

    @Override
    protected String help() {
        return ConfigCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " config SUB_COMMAND [ARGUMENTS]");
        out.println();
        out.println("Where SUB_COMMAND is one of: 'credentials', 'truststore', 'initial-token', 'registration-token'");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help config SUB_COMMAND' for more info.");
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands.");
        return sb.toString();
    }
}

