/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.UUID;
import org.keycloak.credential.CredentialInput;

public class UserCredentialModel
implements CredentialInput {
    @Deprecated
    public static final String PASSWORD = "password";
    @Deprecated
    public static final String PASSWORD_HISTORY = "password-history";
    @Deprecated
    public static final String TOTP = "totp";
    @Deprecated
    public static final String HOTP = "hotp";
    public static final String SECRET = "secret";
    public static final String KERBEROS = "kerberos";
    public static final String CLIENT_CERT = "cert";
    private final String credentialId;
    private final String type;
    private final String challengeResponse;
    private final boolean adminRequest;

    public UserCredentialModel(String credentialId, String type, String challengeResponse) {
        this.credentialId = credentialId;
        this.type = type;
        this.challengeResponse = challengeResponse;
        this.adminRequest = false;
    }

    public UserCredentialModel(String credentialId, String type, String challengeResponse, boolean adminRequest) {
        this.credentialId = credentialId;
        this.type = type;
        this.challengeResponse = challengeResponse;
        this.adminRequest = adminRequest;
    }

    public static UserCredentialModel password(String password) {
        return UserCredentialModel.password(password, false);
    }

    public static UserCredentialModel password(String password, boolean adminRequest) {
        return new UserCredentialModel("", PASSWORD, password, adminRequest);
    }

    public static UserCredentialModel secret(String password) {
        return new UserCredentialModel("", SECRET, password);
    }

    public static UserCredentialModel kerberos(String token) {
        return new UserCredentialModel("", KERBEROS, token);
    }

    public static UserCredentialModel generateSecret() {
        return new UserCredentialModel("", SECRET, UUID.randomUUID().toString());
    }

    @Override
    public String getCredentialId() {
        return this.credentialId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getChallengeResponse() {
        return this.challengeResponse;
    }

    public boolean isAdminRequest() {
        return this.adminRequest;
    }
}

