/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.storage.StorageId;

public class ModelToRepresentation {
    public static void buildGroupPath(StringBuilder sb, GroupModel group) {
        if (group.getParent() != null) {
            ModelToRepresentation.buildGroupPath(sb, group.getParent());
        }
        sb.append('/').append(group.getName());
    }

    public static String buildGroupPath(GroupModel group) {
        StringBuilder sb = new StringBuilder();
        ModelToRepresentation.buildGroupPath(sb, group);
        return sb.toString();
    }

    public static GroupRepresentation toRepresentation(GroupModel group, boolean full) {
        GroupRepresentation rep = new GroupRepresentation();
        rep.setId(group.getId());
        rep.setName(group.getName());
        rep.setPath(ModelToRepresentation.buildGroupPath(group));
        if (!full) {
            return rep;
        }
        Set roles = group.getRoleMappings();
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, List> clientRoleNames = new HashMap<String, List>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client = (ClientModel)role.getContainer();
            String clientId = client.getClientId();
            List currentClientRoles = clientRoleNames.computeIfAbsent(clientId, k -> new ArrayList());
            currentClientRoles.add(role.getName());
        }
        rep.setRealmRoles(realmRoleNames);
        rep.setClientRoles(clientRoleNames);
        Map attributes = group.getAttributes();
        rep.setAttributes(attributes);
        return rep;
    }

    public static List<GroupRepresentation> searchForGroupByName(RealmModel realm, boolean full, String search, Integer first, Integer max) {
        LinkedList<GroupRepresentation> result = new LinkedList<GroupRepresentation>();
        List groups = realm.searchForGroupByName(search, first, max);
        if (Objects.isNull(groups)) {
            return result;
        }
        for (GroupModel group : groups) {
            GroupRepresentation rep = ModelToRepresentation.toGroupHierarchy(group, full);
            result.add(rep);
        }
        return result;
    }

    public static List<GroupRepresentation> searchForGroupByName(UserModel user, boolean full, String search, Integer first, Integer max) {
        return user.getGroups(search, first.intValue(), max.intValue()).stream().map(group -> ModelToRepresentation.toRepresentation(group, full)).collect(Collectors.toList());
    }

    public static List<GroupRepresentation> toGroupHierarchy(RealmModel realm, boolean full, Integer first, Integer max) {
        LinkedList<GroupRepresentation> hierarchy = new LinkedList<GroupRepresentation>();
        List groups = realm.getTopLevelGroups(first, max);
        if (Objects.isNull(groups)) {
            return hierarchy;
        }
        for (GroupModel group : groups) {
            GroupRepresentation rep = ModelToRepresentation.toGroupHierarchy(group, full);
            hierarchy.add(rep);
        }
        return hierarchy;
    }

    public static List<GroupRepresentation> toGroupHierarchy(UserModel user, boolean full, Integer first, Integer max) {
        return user.getGroups(first.intValue(), max.intValue()).stream().map(group -> ModelToRepresentation.toRepresentation(group, full)).collect(Collectors.toList());
    }

    public static List<GroupRepresentation> toGroupHierarchy(RealmModel realm, boolean full) {
        LinkedList<GroupRepresentation> hierarchy = new LinkedList<GroupRepresentation>();
        List groups = realm.getTopLevelGroups();
        if (Objects.isNull(groups)) {
            return hierarchy;
        }
        for (GroupModel group : groups) {
            GroupRepresentation rep = ModelToRepresentation.toGroupHierarchy(group, full);
            hierarchy.add(rep);
        }
        return hierarchy;
    }

    public static List<GroupRepresentation> toGroupHierarchy(UserModel user, boolean full) {
        return user.getGroups().stream().map(group -> ModelToRepresentation.toRepresentation(group, full)).collect(Collectors.toList());
    }

    public static GroupRepresentation toGroupHierarchy(GroupModel group, boolean full) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation(group, full);
        LinkedList<GroupRepresentation> subGroups = new LinkedList<GroupRepresentation>();
        for (GroupModel subGroup : group.getSubGroups()) {
            subGroups.add(ModelToRepresentation.toGroupHierarchy(subGroup, full));
        }
        rep.setSubGroups(subGroups);
        return rep;
    }

    public static UserRepresentation toRepresentation(KeycloakSession session, RealmModel realm, UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        String providerId = StorageId.resolveProviderId((UserModel)user);
        rep.setOrigin(providerId);
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(Boolean.valueOf(user.isEnabled()));
        rep.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        rep.setTotp(Boolean.valueOf(session.userCredentialManager().isConfiguredFor(realm, user, "otp")));
        rep.setDisableableCredentialTypes(session.userCredentialManager().getDisableableCredentialTypes(realm, user));
        rep.setFederationLink(user.getFederationLink());
        rep.setNotBefore(Integer.valueOf(session.users().getNotBeforeOfUser(realm, user)));
        ArrayList reqActions = new ArrayList();
        Set requiredActions = user.getRequiredActions();
        reqActions.addAll(requiredActions);
        rep.setRequiredActions(reqActions);
        if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
            HashMap attrs = new HashMap();
            attrs.putAll(user.getAttributes());
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static UserRepresentation toBriefRepresentation(UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setCreatedTimestamp(user.getCreatedTimestamp());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(Boolean.valueOf(user.isEnabled()));
        rep.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        rep.setFederationLink(user.getFederationLink());
        return rep;
    }

    public static EventRepresentation toRepresentation(Event event) {
        EventRepresentation rep = new EventRepresentation();
        rep.setTime(event.getTime());
        rep.setType(event.getType().toString());
        rep.setRealmId(event.getRealmId());
        rep.setClientId(event.getClientId());
        rep.setUserId(event.getUserId());
        rep.setSessionId(event.getSessionId());
        rep.setIpAddress(event.getIpAddress());
        rep.setError(event.getError());
        rep.setDetails(event.getDetails());
        return rep;
    }

    public static AdminEventRepresentation toRepresentation(AdminEvent adminEvent) {
        AdminEventRepresentation rep = new AdminEventRepresentation();
        rep.setTime(adminEvent.getTime());
        rep.setRealmId(adminEvent.getRealmId());
        if (adminEvent.getAuthDetails() != null) {
            rep.setAuthDetails(ModelToRepresentation.toRepresentation(adminEvent.getAuthDetails()));
        }
        rep.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceTypeAsString() != null) {
            rep.setResourceType(adminEvent.getResourceTypeAsString());
        }
        rep.setResourcePath(adminEvent.getResourcePath());
        rep.setRepresentation(adminEvent.getRepresentation());
        rep.setError(adminEvent.getError());
        return rep;
    }

    public static AuthDetailsRepresentation toRepresentation(AuthDetails authDetails) {
        AuthDetailsRepresentation rep = new AuthDetailsRepresentation();
        rep.setRealmId(authDetails.getRealmId());
        rep.setClientId(authDetails.getClientId());
        rep.setUserId(authDetails.getUserId());
        rep.setIpAddress(authDetails.getIpAddress());
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setComposite(role.isComposite());
        rep.setClientRole(Boolean.valueOf(role.isClientRole()));
        rep.setContainerId(role.getContainerId());
        rep.setAttributes(role.getAttributes());
        return rep;
    }

    public static RoleRepresentation toBriefRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setComposite(role.isComposite());
        rep.setClientRole(Boolean.valueOf(role.isClientRole()));
        rep.setContainerId(role.getContainerId());
        return rep;
    }

    public static RealmRepresentation toRepresentation(RealmModel realm, boolean internal) {
        List requiredCredentialModels;
        List defaultGroups;
        List defaultRoles;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setDisplayName(realm.getDisplayName());
        rep.setDisplayNameHtml(realm.getDisplayNameHtml());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setNotBefore(Integer.valueOf(realm.getNotBefore()));
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(realm.isRegistrationEmailAsUsername()));
        rep.setRememberMe(Boolean.valueOf(realm.isRememberMe()));
        rep.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected()));
        rep.setPermanentLockout(Boolean.valueOf(realm.isPermanentLockout()));
        rep.setMaxFailureWaitSeconds(Integer.valueOf(realm.getMaxFailureWaitSeconds()));
        rep.setMinimumQuickLoginWaitSeconds(Integer.valueOf(realm.getMinimumQuickLoginWaitSeconds()));
        rep.setWaitIncrementSeconds(Integer.valueOf(realm.getWaitIncrementSeconds()));
        rep.setQuickLoginCheckMilliSeconds(Long.valueOf(realm.getQuickLoginCheckMilliSeconds()));
        rep.setMaxDeltaTimeSeconds(Integer.valueOf(realm.getMaxDeltaTimeSeconds()));
        rep.setFailureFactor(Integer.valueOf(realm.getFailureFactor()));
        rep.setUserManagedAccessAllowed(Boolean.valueOf(realm.isUserManagedAccessAllowed()));
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(realm.getEventsExpiration());
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setLoginWithEmailAllowed(Boolean.valueOf(realm.isLoginWithEmailAllowed()));
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(realm.isDuplicateEmailsAllowed()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setEditUsernameAllowed(Boolean.valueOf(realm.isEditUsernameAllowed()));
        rep.setDefaultSignatureAlgorithm(realm.getDefaultSignatureAlgorithm());
        rep.setRevokeRefreshToken(Boolean.valueOf(realm.isRevokeRefreshToken()));
        rep.setRefreshTokenMaxReuse(Integer.valueOf(realm.getRefreshTokenMaxReuse()));
        rep.setAccessTokenLifespan(Integer.valueOf(realm.getAccessTokenLifespan()));
        rep.setAccessTokenLifespanForImplicitFlow(Integer.valueOf(realm.getAccessTokenLifespanForImplicitFlow()));
        rep.setSsoSessionIdleTimeout(Integer.valueOf(realm.getSsoSessionIdleTimeout()));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(realm.getSsoSessionMaxLifespan()));
        rep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(realm.getSsoSessionIdleTimeoutRememberMe()));
        rep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(realm.getSsoSessionMaxLifespanRememberMe()));
        rep.setOfflineSessionIdleTimeout(Integer.valueOf(realm.getOfflineSessionIdleTimeout()));
        rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(realm.isOfflineSessionMaxLifespanEnabled()));
        rep.setOfflineSessionMaxLifespan(Integer.valueOf(realm.getOfflineSessionMaxLifespan()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(realm.getAccessCodeLifespanLogin()));
        rep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(realm.getActionTokenGeneratedByAdminLifespan()));
        rep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(realm.getActionTokenGeneratedByUserLifespan()));
        rep.setSmtpServer(new HashMap(realm.getSmtpConfig()));
        rep.setBrowserSecurityHeaders(realm.getBrowserSecurityHeaders());
        rep.setAccountTheme(realm.getAccountTheme());
        rep.setLoginTheme(realm.getLoginTheme());
        rep.setAdminTheme(realm.getAdminTheme());
        rep.setEmailTheme(realm.getEmailTheme());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        OTPPolicy otpPolicy = realm.getOTPPolicy();
        rep.setOtpPolicyAlgorithm(otpPolicy.getAlgorithm());
        rep.setOtpPolicyPeriod(Integer.valueOf(otpPolicy.getPeriod()));
        rep.setOtpPolicyDigits(Integer.valueOf(otpPolicy.getDigits()));
        rep.setOtpPolicyInitialCounter(Integer.valueOf(otpPolicy.getInitialCounter()));
        rep.setOtpPolicyType(otpPolicy.getType());
        rep.setOtpPolicyLookAheadWindow(Integer.valueOf(otpPolicy.getLookAheadWindow()));
        rep.setOtpSupportedApplications(otpPolicy.getSupportedApplications());
        WebAuthnPolicy webAuthnPolicy = realm.getWebAuthnPolicy();
        rep.setWebAuthnPolicyRpEntityName(webAuthnPolicy.getRpEntityName());
        rep.setWebAuthnPolicySignatureAlgorithms(webAuthnPolicy.getSignatureAlgorithm());
        rep.setWebAuthnPolicyRpId(webAuthnPolicy.getRpId());
        rep.setWebAuthnPolicyAttestationConveyancePreference(webAuthnPolicy.getAttestationConveyancePreference());
        rep.setWebAuthnPolicyAuthenticatorAttachment(webAuthnPolicy.getAuthenticatorAttachment());
        rep.setWebAuthnPolicyRequireResidentKey(webAuthnPolicy.getRequireResidentKey());
        rep.setWebAuthnPolicyUserVerificationRequirement(webAuthnPolicy.getUserVerificationRequirement());
        rep.setWebAuthnPolicyCreateTimeout(Integer.valueOf(webAuthnPolicy.getCreateTimeout()));
        rep.setWebAuthnPolicyAvoidSameAuthenticatorRegister(Boolean.valueOf(webAuthnPolicy.isAvoidSameAuthenticatorRegister()));
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicy.getAcceptableAaguids());
        if (realm.getBrowserFlow() != null) {
            rep.setBrowserFlow(realm.getBrowserFlow().getAlias());
        }
        if (realm.getRegistrationFlow() != null) {
            rep.setRegistrationFlow(realm.getRegistrationFlow().getAlias());
        }
        if (realm.getDirectGrantFlow() != null) {
            rep.setDirectGrantFlow(realm.getDirectGrantFlow().getAlias());
        }
        if (realm.getResetCredentialsFlow() != null) {
            rep.setResetCredentialsFlow(realm.getResetCredentialsFlow().getAlias());
        }
        if (realm.getClientAuthenticationFlow() != null) {
            rep.setClientAuthenticationFlow(realm.getClientAuthenticationFlow().getAlias());
        }
        if (realm.getDockerAuthenticationFlow() != null) {
            rep.setDockerAuthenticationFlow(realm.getDockerAuthenticationFlow().getAlias());
        }
        if (!(defaultRoles = realm.getDefaultRoles()).isEmpty()) {
            ArrayList roleStrings = new ArrayList();
            roleStrings.addAll(defaultRoles);
            rep.setDefaultRoles(roleStrings);
        }
        if (!(defaultGroups = realm.getDefaultGroups()).isEmpty()) {
            LinkedList<String> groupPaths = new LinkedList<String>();
            for (GroupModel group : defaultGroups) {
                groupPaths.add(ModelToRepresentation.buildGroupPath(group));
            }
            rep.setDefaultGroups(groupPaths);
        }
        if ((requiredCredentialModels = realm.getRequiredCredentials()).size() > 0) {
            rep.setRequiredCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredCredentialModels) {
                rep.getRequiredCredentials().add(cred.getType());
            }
        }
        for (IdentityProviderModel provider : realm.getIdentityProviders()) {
            rep.addIdentityProvider(ModelToRepresentation.toRepresentation(realm, provider));
        }
        for (IdentityProviderMapperModel mapper : realm.getIdentityProviderMappers()) {
            rep.addIdentityProviderMapper(ModelToRepresentation.toRepresentation(mapper));
        }
        rep.setInternationalizationEnabled(Boolean.valueOf(realm.isInternationalizationEnabled()));
        if (realm.getSupportedLocales() != null) {
            rep.setSupportedLocales(new HashSet());
            rep.getSupportedLocales().addAll(realm.getSupportedLocales());
        }
        rep.setDefaultLocale(realm.getDefaultLocale());
        if (internal) {
            ModelToRepresentation.exportAuthenticationFlows(realm, rep);
            ModelToRepresentation.exportRequiredActions(realm, rep);
            ModelToRepresentation.exportGroups(realm, rep);
        }
        Map attributes = realm.getAttributes();
        rep.setAttributes(attributes);
        if (!internal) {
            rep = StripSecretsUtils.strip(rep);
        }
        return rep;
    }

    public static void exportGroups(RealmModel realm, RealmRepresentation rep) {
        List<GroupRepresentation> groups = ModelToRepresentation.toGroupHierarchy(realm, true);
        rep.setGroups(groups);
    }

    public static void exportAuthenticationFlows(RealmModel realm, RealmRepresentation rep) {
        rep.setAuthenticationFlows(new LinkedList());
        rep.setAuthenticatorConfig(new LinkedList());
        ArrayList authenticationFlows = new ArrayList(realm.getAuthenticationFlows());
        Collections.sort(authenticationFlows, new Comparator<AuthenticationFlowModel>(){

            @Override
            public int compare(AuthenticationFlowModel left, AuthenticationFlowModel right) {
                String l = left.getAlias() != null ? left.getAlias() : "\u0000";
                String r = right.getAlias() != null ? right.getAlias() : "\u0000";
                return l.compareTo(r);
            }
        });
        for (AuthenticationFlowModel model : authenticationFlows) {
            AuthenticationFlowRepresentation flowRep = ModelToRepresentation.toRepresentation(realm, model);
            rep.getAuthenticationFlows().add(flowRep);
        }
        ArrayList authenticatorConfigs = new ArrayList(realm.getAuthenticatorConfigs());
        Collections.sort(authenticatorConfigs, new Comparator<AuthenticatorConfigModel>(){

            @Override
            public int compare(AuthenticatorConfigModel left, AuthenticatorConfigModel right) {
                String l = left.getAlias() != null ? left.getAlias() : "\u0000";
                String r = right.getAlias() != null ? right.getAlias() : "\u0000";
                return l.compareTo(r);
            }
        });
        for (AuthenticatorConfigModel model : authenticatorConfigs) {
            rep.getAuthenticatorConfig().add(ModelToRepresentation.toRepresentation(model));
        }
    }

    public static void exportRequiredActions(RealmModel realm, RealmRepresentation rep) {
        rep.setRequiredActions(new LinkedList());
        realm.getRequiredActionProviders().forEach(action -> rep.getRequiredActions().add(ModelToRepresentation.toRepresentation(action)));
    }

    public static RealmEventsConfigRepresentation toEventsConfigReprensetation(RealmModel realm) {
        RealmEventsConfigRepresentation rep = new RealmEventsConfigRepresentation();
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(realm.getEventsExpiration()));
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList(realm.getEventsListeners()));
        }
        if (realm.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList(realm.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(realm.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(realm.isAdminEventsDetailsEnabled()));
        return rep;
    }

    public static CredentialRepresentation toRepresentation(UserCredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("secret");
        rep.setValue(cred.getChallengeResponse());
        return rep;
    }

    public static CredentialRepresentation toRepresentation(CredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setId(cred.getId());
        rep.setType(cred.getType());
        rep.setUserLabel(cred.getUserLabel());
        rep.setCreatedDate(cred.getCreatedDate());
        rep.setSecretData(cred.getSecretData());
        rep.setCredentialData(cred.getCredentialData());
        return rep;
    }

    public static FederatedIdentityRepresentation toRepresentation(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation rep = new FederatedIdentityRepresentation();
        rep.setUserName(socialLink.getUserName());
        rep.setIdentityProvider(socialLink.getIdentityProvider());
        rep.setUserId(socialLink.getUserId());
        return rep;
    }

    public static UserSessionRepresentation toRepresentation(UserSessionModel session) {
        UserSessionRepresentation rep = new UserSessionRepresentation();
        rep.setId(session.getId());
        rep.setStart(Time.toMillis((int)session.getStarted()));
        rep.setLastAccess(Time.toMillis((int)session.getLastSessionRefresh()));
        rep.setUsername(session.getUser().getUsername());
        rep.setUserId(session.getUser().getId());
        rep.setIpAddress(session.getIpAddress());
        for (AuthenticatedClientSessionModel clientSession : session.getAuthenticatedClientSessions().values()) {
            ClientModel client = clientSession.getClient();
            rep.getClients().put(client.getId(), client.getClientId());
        }
        return rep;
    }

    public static ClientScopeRepresentation toRepresentation(ClientScopeModel clientScopeModel) {
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setId(clientScopeModel.getId());
        rep.setName(clientScopeModel.getName());
        rep.setDescription(clientScopeModel.getDescription());
        rep.setProtocol(clientScopeModel.getProtocol());
        if (!clientScopeModel.getProtocolMappers().isEmpty()) {
            LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel model : clientScopeModel.getProtocolMappers()) {
                mappings.add(ModelToRepresentation.toRepresentation(model));
            }
            rep.setProtocolMappers(mappings);
        }
        rep.setAttributes(new HashMap(clientScopeModel.getAttributes()));
        return rep;
    }

    public static ClientRepresentation toRepresentation(ClientModel clientModel, KeycloakSession session) {
        AuthorizationProvider authorization;
        ResourceServer resourceServer;
        Set webOrigins;
        ClientRepresentation rep = new ClientRepresentation();
        rep.setId(clientModel.getId());
        String providerId = StorageId.resolveProviderId((ClientModel)clientModel);
        rep.setOrigin(providerId);
        rep.setClientId(clientModel.getClientId());
        rep.setName(clientModel.getName());
        rep.setDescription(clientModel.getDescription());
        rep.setEnabled(Boolean.valueOf(clientModel.isEnabled()));
        rep.setAdminUrl(clientModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(clientModel.isPublicClient()));
        rep.setFrontchannelLogout(Boolean.valueOf(clientModel.isFrontchannelLogout()));
        rep.setProtocol(clientModel.getProtocol());
        rep.setAttributes(clientModel.getAttributes());
        rep.setAuthenticationFlowBindingOverrides(clientModel.getAuthenticationFlowBindingOverrides());
        rep.setFullScopeAllowed(Boolean.valueOf(clientModel.isFullScopeAllowed()));
        rep.setBearerOnly(Boolean.valueOf(clientModel.isBearerOnly()));
        rep.setConsentRequired(Boolean.valueOf(clientModel.isConsentRequired()));
        rep.setStandardFlowEnabled(Boolean.valueOf(clientModel.isStandardFlowEnabled()));
        rep.setImplicitFlowEnabled(Boolean.valueOf(clientModel.isImplicitFlowEnabled()));
        rep.setDirectAccessGrantsEnabled(Boolean.valueOf(clientModel.isDirectAccessGrantsEnabled()));
        rep.setServiceAccountsEnabled(Boolean.valueOf(clientModel.isServiceAccountsEnabled()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(clientModel.isSurrogateAuthRequired()));
        rep.setRootUrl(clientModel.getRootUrl());
        rep.setBaseUrl(clientModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(clientModel.getNotBefore()));
        rep.setNodeReRegistrationTimeout(Integer.valueOf(clientModel.getNodeReRegistrationTimeout()));
        rep.setClientAuthenticatorType(clientModel.getClientAuthenticatorType());
        rep.setDefaultClientScopes(new LinkedList(clientModel.getClientScopes(true, false).keySet()));
        rep.setOptionalClientScopes(new LinkedList(clientModel.getClientScopes(false, false).keySet()));
        Set redirectUris = clientModel.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList(redirectUris));
        }
        if ((webOrigins = clientModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList(webOrigins));
        }
        if (!clientModel.getDefaultRoles().isEmpty()) {
            rep.setDefaultRoles(clientModel.getDefaultRoles().toArray(new String[0]));
        }
        if (!clientModel.getRegisteredNodes().isEmpty()) {
            rep.setRegisteredNodes(new HashMap(clientModel.getRegisteredNodes()));
        }
        if (!clientModel.getProtocolMappers().isEmpty()) {
            LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel model : clientModel.getProtocolMappers()) {
                mappings.add(ModelToRepresentation.toRepresentation(model));
            }
            rep.setProtocolMappers(mappings);
        }
        if ((resourceServer = (authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class)).getStoreFactory().getResourceServerStore().findById(clientModel.getId())) != null) {
            rep.setAuthorizationServicesEnabled(Boolean.valueOf(true));
        }
        return rep;
    }

    public static IdentityProviderRepresentation toRepresentation(RealmModel realm, IdentityProviderModel identityProviderModel) {
        String postBrokerLoginFlowId;
        IdentityProviderRepresentation providerRep = new IdentityProviderRepresentation();
        providerRep.setInternalId(identityProviderModel.getInternalId());
        providerRep.setProviderId(identityProviderModel.getProviderId());
        providerRep.setAlias(identityProviderModel.getAlias());
        providerRep.setDisplayName(identityProviderModel.getDisplayName());
        providerRep.setEnabled(identityProviderModel.isEnabled());
        providerRep.setLinkOnly(identityProviderModel.isLinkOnly());
        providerRep.setStoreToken(identityProviderModel.isStoreToken());
        providerRep.setTrustEmail(identityProviderModel.isTrustEmail());
        providerRep.setAuthenticateByDefault(identityProviderModel.isAuthenticateByDefault());
        HashMap config = new HashMap();
        config.putAll(identityProviderModel.getConfig());
        providerRep.setConfig(config);
        providerRep.setAddReadTokenRoleOnCreate(identityProviderModel.isAddReadTokenRoleOnCreate());
        String firstBrokerLoginFlowId = identityProviderModel.getFirstBrokerLoginFlowId();
        if (firstBrokerLoginFlowId != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(firstBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + firstBrokerLoginFlowId);
            }
            providerRep.setFirstBrokerLoginFlowAlias(flow.getAlias());
        }
        if ((postBrokerLoginFlowId = identityProviderModel.getPostBrokerLoginFlowId()) != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(postBrokerLoginFlowId);
            if (flow == null) {
                throw new ModelException("Couldn't find authentication flow with id " + postBrokerLoginFlowId);
            }
            providerRep.setPostBrokerLoginFlowAlias(flow.getAlias());
        }
        return providerRep;
    }

    public static ProtocolMapperRepresentation toRepresentation(ProtocolMapperModel model) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setId(model.getId());
        rep.setProtocol(model.getProtocol());
        HashMap config = new HashMap();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        rep.setProtocolMapper(model.getProtocolMapper());
        return rep;
    }

    public static IdentityProviderMapperRepresentation toRepresentation(IdentityProviderMapperModel model) {
        IdentityProviderMapperRepresentation rep = new IdentityProviderMapperRepresentation();
        rep.setId(model.getId());
        rep.setIdentityProviderMapper(model.getIdentityProviderMapper());
        rep.setIdentityProviderAlias(model.getIdentityProviderAlias());
        HashMap config = new HashMap();
        config.putAll(model.getConfig());
        rep.setConfig(config);
        rep.setName(model.getName());
        return rep;
    }

    public static UserConsentRepresentation toRepresentation(UserConsentModel model) {
        String clientId = model.getClient().getClientId();
        LinkedList<String> grantedClientScopes = new LinkedList<String>();
        for (ClientScopeModel clientScope : model.getGrantedClientScopes()) {
            if (clientScope instanceof ClientModel) {
                grantedClientScopes.add(((ClientModel)clientScope).getClientId());
                continue;
            }
            grantedClientScopes.add(clientScope.getName());
        }
        UserConsentRepresentation consentRep = new UserConsentRepresentation();
        consentRep.setClientId(clientId);
        consentRep.setGrantedClientScopes(grantedClientScopes);
        consentRep.setCreatedDate(model.getCreatedDate());
        consentRep.setLastUpdatedDate(model.getLastUpdatedDate());
        return consentRep;
    }

    public static AuthenticationFlowRepresentation toRepresentation(RealmModel realm, AuthenticationFlowModel model) {
        AuthenticationFlowRepresentation rep = new AuthenticationFlowRepresentation();
        rep.setId(model.getId());
        rep.setBuiltIn(model.isBuiltIn());
        rep.setTopLevel(model.isTopLevel());
        rep.setProviderId(model.getProviderId());
        rep.setAlias(model.getAlias());
        rep.setDescription(model.getDescription());
        rep.setAuthenticationExecutions(new LinkedList());
        for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(model.getId())) {
            rep.getAuthenticationExecutions().add(ModelToRepresentation.toRepresentation(realm, execution));
        }
        return rep;
    }

    public static AuthenticationExecutionExportRepresentation toRepresentation(RealmModel realm, AuthenticationExecutionModel model) {
        AuthenticationExecutionExportRepresentation rep = new AuthenticationExecutionExportRepresentation();
        if (model.getAuthenticatorConfig() != null) {
            AuthenticatorConfigModel config = realm.getAuthenticatorConfigById(model.getAuthenticatorConfig());
            rep.setAuthenticatorConfig(config.getAlias());
        }
        rep.setAuthenticator(model.getAuthenticator());
        rep.setAutheticatorFlow(model.isAuthenticatorFlow());
        if (model.getFlowId() != null) {
            AuthenticationFlowModel flow = realm.getAuthenticationFlowById(model.getFlowId());
            rep.setFlowAlias(flow.getAlias());
        }
        rep.setPriority(model.getPriority());
        rep.setRequirement(model.getRequirement().name());
        return rep;
    }

    public static AuthenticatorConfigRepresentation toRepresentation(AuthenticatorConfigModel model) {
        AuthenticatorConfigRepresentation rep = new AuthenticatorConfigRepresentation();
        rep.setId(model.getId());
        rep.setAlias(model.getAlias());
        rep.setConfig(model.getConfig());
        return rep;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        rep.setName(model.getName());
        rep.setProviderId(model.getProviderId());
        rep.setPriority(model.getPriority());
        return rep;
    }

    public static List<ConfigPropertyRepresentation> toRepresentation(List<ProviderConfigProperty> configProperties) {
        LinkedList<ConfigPropertyRepresentation> propertiesRep = new LinkedList<ConfigPropertyRepresentation>();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = ModelToRepresentation.toRepresentation(prop);
            propertiesRep.add(propRep);
        }
        return propertiesRep;
    }

    public static ConfigPropertyRepresentation toRepresentation(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setOptions(prop.getOptions());
        propRep.setHelpText(prop.getHelpText());
        propRep.setSecret(prop.isSecret());
        return propRep;
    }

    public static ComponentRepresentation toRepresentation(KeycloakSession session, ComponentModel component, boolean internal) {
        ComponentRepresentation rep = ModelToRepresentation.toRepresentationWithoutConfig(component);
        if (!internal) {
            rep = StripSecretsUtils.strip(session, rep);
        }
        return rep;
    }

    public static ComponentRepresentation toRepresentationWithoutConfig(ComponentModel component) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setId(component.getId());
        rep.setName(component.getName());
        rep.setProviderId(component.getProviderId());
        rep.setProviderType(component.getProviderType());
        rep.setSubType(component.getSubType());
        rep.setParentId(component.getParentId());
        rep.setConfig(new MultivaluedHashMap(component.getConfig()));
        return rep;
    }

    public static ScopeRepresentation toRepresentation(Scope model) {
        ScopeRepresentation scope = new ScopeRepresentation();
        scope.setId(model.getId());
        scope.setName(model.getName());
        scope.setDisplayName(model.getDisplayName());
        scope.setIconUri(model.getIconUri());
        return scope;
    }

    public static ResourceServerRepresentation toRepresentation(ResourceServer model, ClientModel client) {
        ResourceServerRepresentation server = new ResourceServerRepresentation();
        server.setId(model.getId());
        server.setClientId(model.getId());
        server.setName(client.getClientId());
        server.setAllowRemoteResourceManagement(model.isAllowRemoteResourceManagement());
        server.setPolicyEnforcementMode(model.getPolicyEnforcementMode());
        server.setDecisionStrategy(model.getDecisionStrategy());
        return server;
    }

    public static <R extends AbstractPolicyRepresentation> R toRepresentation(Policy policy, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(policy, authorization, false, true);
    }

    public static <R extends AbstractPolicyRepresentation> R toRepresentation(Policy policy, AuthorizationProvider authorization, boolean genericRepresentation, boolean export) {
        Object representation;
        PolicyProviderFactory providerFactory = authorization.getProviderFactory(policy.getType());
        if (genericRepresentation || export) {
            representation = new PolicyRepresentation();
            ((PolicyRepresentation)PolicyRepresentation.class.cast(representation)).setConfig(policy.getConfig());
            if (export) {
                providerFactory.onExport(policy, (PolicyRepresentation)PolicyRepresentation.class.cast(representation), authorization);
            }
        } else {
            try {
                representation = providerFactory.toRepresentation(policy, authorization);
            }
            catch (Exception cause) {
                throw new RuntimeException("Could not create policy [" + policy.getType() + "] representation", cause);
            }
        }
        representation.setId(policy.getId());
        representation.setName(policy.getName());
        representation.setDescription(policy.getDescription());
        representation.setType(policy.getType());
        representation.setDecisionStrategy(policy.getDecisionStrategy());
        representation.setLogic(policy.getLogic());
        return (R)representation;
    }

    public static ResourceRepresentation toRepresentation(Resource model, ResourceServer resourceServer, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(model, resourceServer, authorization, (Boolean)true);
    }

    public static ResourceRepresentation toRepresentation(Resource model, ResourceServer resourceServer, AuthorizationProvider authorization, Boolean deep) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(model.getId());
        resource.setType(model.getType());
        resource.setName(model.getName());
        resource.setDisplayName(model.getDisplayName());
        resource.setUris(model.getUris());
        resource.setIconUri(model.getIconUri());
        resource.setOwnerManagedAccess(Boolean.valueOf(model.isOwnerManagedAccess()));
        ResourceOwnerRepresentation owner = new ResourceOwnerRepresentation();
        owner.setId(model.getOwner());
        KeycloakSession keycloakSession = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        if (owner.getId().equals(resourceServer.getId())) {
            ClientModel clientModel = realm.getClientById(resourceServer.getId());
            owner.setName(clientModel.getClientId());
        } else {
            UserModel userModel = keycloakSession.users().getUserById(owner.getId(), realm);
            if (userModel == null) {
                throw new RuntimeException("Could not find the user [" + owner.getId() + "] who owns the Resource [" + resource.getId() + "].");
            }
            owner.setName(userModel.getUsername());
        }
        resource.setOwner(owner);
        if (deep.booleanValue()) {
            resource.setScopes(model.getScopes().stream().map(model1 -> {
                ScopeRepresentation scope = new ScopeRepresentation();
                scope.setId(model1.getId());
                scope.setName(model1.getName());
                String iconUri = model1.getIconUri();
                if (iconUri != null) {
                    scope.setIconUri(iconUri);
                }
                return scope;
            }).collect(Collectors.toSet()));
            resource.setAttributes(new HashMap<String, List<String>>(model.getAttributes()));
        }
        return resource;
    }

    public static PermissionTicketRepresentation toRepresentation(PermissionTicket ticket, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation(ticket, authorization, false);
    }

    public static PermissionTicketRepresentation toRepresentation(PermissionTicket ticket, AuthorizationProvider authorization, boolean returnNames) {
        Scope scope;
        PermissionTicketRepresentation representation = new PermissionTicketRepresentation();
        representation.setId(ticket.getId());
        representation.setGranted(ticket.isGranted());
        representation.setOwner(ticket.getOwner());
        representation.setRequester(ticket.getRequester());
        Resource resource = ticket.getResource();
        representation.setResource(resource.getId());
        if (returnNames) {
            representation.setResourceName(resource.getName());
            KeycloakSession keycloakSession = authorization.getKeycloakSession();
            RealmModel realm = authorization.getRealm();
            UserModel owner = keycloakSession.users().getUserById(ticket.getOwner(), realm);
            UserModel requester = keycloakSession.users().getUserById(ticket.getRequester(), realm);
            representation.setRequesterName(requester.getUsername());
            representation.setOwnerName(owner.getUsername());
        }
        if ((scope = ticket.getScope()) != null) {
            representation.setScope(scope.getId());
            if (returnNames) {
                representation.setScopeName(scope.getName());
            }
        }
        return representation;
    }
}

