/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedGroup;

public class GroupAdapter
implements GroupModel {
    protected final CachedGroup cached;
    protected final RealmCacheSession cacheSession;
    protected final KeycloakSession keycloakSession;
    protected final RealmModel realm;
    private final Supplier<GroupModel> modelSupplier;
    protected volatile GroupModel updated;
    protected volatile boolean invalidated;

    public GroupAdapter(CachedGroup cached, RealmCacheSession cacheSession, KeycloakSession keycloakSession, RealmModel realm) {
        this.cached = cached;
        this.cacheSession = cacheSession;
        this.keycloakSession = keycloakSession;
        this.realm = realm;
        this.modelSupplier = this::getGroupModel;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerGroupInvalidation(this.cached.getId());
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getRealmDelegate().getGroupById(this.cached.getId(), this.realm);
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GroupModel)) {
            return false;
        }
        GroupModel that = (GroupModel)o;
        return this.cached.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.cached.getId().hashCode();
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public void setSingleAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setSingleAttribute(name, value);
    }

    public void setAttribute(String name, List<String> values) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getFirstAttribute(name);
        }
        return (String)this.cached.getAttributes(this.modelSupplier).getFirst((Object)name);
    }

    public List<String> getAttribute(String name) {
        List values = (List)this.cached.getAttributes(this.modelSupplier).get((Object)name);
        if (values == null) {
            return null;
        }
        return values;
    }

    public Map<String, List<String>> getAttributes() {
        return this.cached.getAttributes(this.modelSupplier);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        if (this.isUpdated()) {
            return this.updated.getRealmRoleMappings();
        }
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmMappings = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            realmMappings.add(role);
        }
        return realmMappings;
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        if (this.isUpdated()) {
            return this.updated.getClientRoleMappings(app);
        }
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> appMappings = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !((ClientModel)container).getId().equals(app.getId())) continue;
            appMappings.add(role);
        }
        return appMappings;
    }

    public boolean hasRole(RoleModel role) {
        if (this.isUpdated()) {
            return this.updated.hasRole(role);
        }
        if (this.cached.getRoleMappings(this.modelSupplier).contains(role.getId())) {
            return true;
        }
        Set<RoleModel> mappings = this.getRoleMappings();
        for (RoleModel mapping : mappings) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void grantRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.grantRole(role);
    }

    public Set<RoleModel> getRoleMappings() {
        if (this.isUpdated()) {
            return this.updated.getRoleMappings();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRoleMappings(this.modelSupplier)) {
            RoleModel roleById = this.keycloakSession.realms().getRoleById(id, this.realm);
            if (roleById == null) {
                this.getDelegateForUpdate();
                return this.updated.getRoleMappings();
            }
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.deleteRoleMapping(role);
    }

    public GroupModel getParent() {
        if (this.isUpdated()) {
            return this.updated.getParent();
        }
        if (this.cached.getParentId() == null) {
            return null;
        }
        return this.keycloakSession.realms().getGroupById(this.cached.getParentId(), this.realm);
    }

    public String getParentId() {
        if (this.isUpdated()) {
            return this.updated.getParentId();
        }
        return this.cached.getParentId();
    }

    public Set<GroupModel> getSubGroups() {
        if (this.isUpdated()) {
            return this.updated.getSubGroups();
        }
        HashSet<GroupModel> subGroups = new HashSet<GroupModel>();
        for (String id : this.cached.getSubGroups(this.modelSupplier)) {
            GroupModel subGroup = this.keycloakSession.realms().getGroupById(id, this.realm);
            if (subGroup == null) {
                this.getDelegateForUpdate();
                return this.updated.getSubGroups();
            }
            subGroups.add(subGroup);
        }
        return subGroups;
    }

    public void setParent(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.setParent(group);
    }

    public void addChild(GroupModel subGroup) {
        this.getDelegateForUpdate();
        this.updated.addChild(subGroup);
    }

    public void removeChild(GroupModel subGroup) {
        this.getDelegateForUpdate();
        this.updated.removeChild(subGroup);
    }

    private GroupModel getGroupModel() {
        return this.cacheSession.getRealmDelegate().getGroupById(this.cached.getId(), this.realm);
    }
}

