/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.repository;

import java.util.Map;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import org.apache.maven.repository.legacy.repository.ArtifactRepositoryFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactRepositoryFactory.class)
public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    private String globalUpdatePolicy;
    private String globalChecksumPolicy;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;

    @Override
    public ArtifactRepositoryLayout getLayout(String layoutId) throws UnknownRepositoryLayoutException {
        return this.repositoryLayouts.get(layoutId);
    }

    @Override
    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, String layoutId, boolean uniqueVersion) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createDeploymentArtifactRepository(id, url, layout, uniqueVersion);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws UnknownRepositoryLayoutException {
        if (layout == null) {
            throw new UnknownRepositoryLayoutException(repositoryId, layoutId);
        }
    }

    @Override
    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, boolean uniqueVersion) {
        return this.createArtifactRepository(id, url, repositoryLayout, null, null);
    }

    @Override
    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    @Override
    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        if (this.globalUpdatePolicy != null) {
            snapshots.setUpdatePolicy(this.globalUpdatePolicy);
            releases.setUpdatePolicy(this.globalUpdatePolicy);
        }
        if (this.globalChecksumPolicy != null) {
            snapshots.setChecksumPolicy(this.globalChecksumPolicy);
            releases.setChecksumPolicy(this.globalChecksumPolicy);
        }
        Object repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    @Override
    public void setGlobalUpdatePolicy(String updatePolicy) {
        this.globalUpdatePolicy = updatePolicy;
    }

    @Override
    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.globalChecksumPolicy = checksumPolicy;
    }
}

