/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.build;

import com.openshift.internal.restclient.model.EnvironmentVariable;
import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IEnvironmentVariable;
import com.openshift.restclient.model.build.ISourceBuildStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SourceBuildStrategy
extends ModelNodeAdapter
implements ISourceBuildStrategy,
ResourcePropertyKeys {
    public static final String FROM_IMAGE = "sourceStrategy.from.name";
    public static final String FROM_KIND = "sourceStrategy.from.kind";
    public static final String FROM_NAMESPACE = "sourceStrategy.from.namespace";
    public static final String SCRIPTS = "sourceStrategy.scripts";
    public static final String INCREMENTAL = "sourceStrategy.incremental";
    public static final String ENV = "sourceStrategy.env";

    public SourceBuildStrategy(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
        JBossDmrExtentions.set(node, propertyKeys, "type", "Source");
    }

    @Override
    public String getType() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "type");
    }

    @Override
    public String getFromNamespace() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), FROM_NAMESPACE);
    }

    @Override
    public void setFromNamespace(String namespace) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), FROM_NAMESPACE, namespace);
    }

    @Override
    public String getFromKind() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), FROM_KIND);
    }

    @Override
    public void setFromKind(String kind) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), FROM_KIND, kind);
    }

    @Override
    public DockerImageURI getImage() {
        return new DockerImageURI(JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), FROM_IMAGE));
    }

    @Override
    public void setImage(DockerImageURI image) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), FROM_IMAGE, image.toString());
    }

    @Override
    public String getScriptsLocation() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), SCRIPTS);
    }

    @Override
    public void setScriptsLocation(String location) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), SCRIPTS, location);
    }

    @Override
    public Collection<IEnvironmentVariable> getEnvVars() {
        String[] path = JBossDmrExtentions.getPath(this.getPropertyKeys(), ENV);
        ModelNode envNode = this.getNode().get(path);
        if (envNode.isDefined()) {
            return envNode.asList().stream().map(n -> new EnvironmentVariable((ModelNode)n, this.getPropertyKeys())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void setEnvVars(Collection<IEnvironmentVariable> envVars) {
        if (envVars == null) {
            return;
        }
        String[] path = JBossDmrExtentions.getPath(this.getPropertyKeys(), ENV);
        ModelNode envNode = this.getNode().get(path);
        envNode.clear();
        envVars.forEach(v -> envNode.add(ModelNode.fromJSONString((String)v.toJson())));
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        String[] path = JBossDmrExtentions.getPath(this.getPropertyKeys(), ENV);
        ModelNode env = this.getNode().get(path);
        HashMap<String, String> values = new HashMap<String, String>();
        if (env.getType() == ModelType.LIST) {
            for (ModelNode value : env.asList()) {
                values.put(value.get("name").asString(), value.get("value").asString());
            }
        }
        return values;
    }

    @Override
    public void setEnvironmentVariables(Map<String, String> envVars) {
        String[] path = JBossDmrExtentions.getPath(this.getPropertyKeys(), ENV);
        ModelNode env = this.getNode().get(path);
        env.clear();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            ModelNode var = new ModelNode();
            var.get("name").set(entry.getKey());
            var.get("value").set(entry.getValue());
            env.add(var);
        }
    }

    @Override
    public boolean incremental() {
        return JBossDmrExtentions.asBoolean(this.getNode(), this.getPropertyKeys(), INCREMENTAL);
    }

    @Override
    public void setIncremental(boolean isIncremental) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), INCREMENTAL, isIncremental);
    }
}

