/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Collection;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;

public class LDAPStorageMapperManager {
    private final LDAPStorageProvider ldapProvider;

    public LDAPStorageMapperManager(LDAPStorageProvider ldapProvider) {
        this.ldapProvider = ldapProvider;
    }

    public LDAPStorageMapper getMapper(ComponentModel mapperModel) {
        LDAPStorageMapper ldapMapper = (LDAPStorageMapper)this.ldapProvider.getSession().getProvider(LDAPStorageMapper.class, mapperModel);
        if (ldapMapper == null) {
            throw new ModelException("Can't find mapper type with ID: " + mapperModel.getProviderId());
        }
        return ldapMapper;
    }

    public List<ComponentModel> sortMappersAsc(Collection<ComponentModel> mappers) {
        return LDAPMappersComparator.sortAsc(this.ldapProvider.getLdapIdentityStore().getConfig(), mappers);
    }

    public List<ComponentModel> sortMappersDesc(Collection<ComponentModel> mappers) {
        return LDAPMappersComparator.sortDesc(this.ldapProvider.getLdapIdentityStore().getConfig(), mappers);
    }
}

