/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;

public class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    private byte[] authenticatorData;
    private byte[] signature;
    private byte[] userHandle;

    public AuthenticatorAssertionResponse(byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, byte[] userHandle) {
        super(clientDataJSON);
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.userHandle = userHandle;
    }

    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone((byte[])this.authenticatorData);
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public byte[] getUserHandle() {
        return ArrayUtil.clone((byte[])this.userHandle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAssertionResponse that = (AuthenticatorAssertionResponse)o;
        return Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature) && Arrays.equals(this.userHandle, that.userHandle);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        return result;
    }
}

