/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AbstractWebAuthnContext;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WebAuthnAuthenticationContext
extends AbstractWebAuthnContext {
    private final byte[] credentialId;
    private final byte[] authenticatorData;
    private final byte[] signature;
    private final byte[] userHandle;

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, byte[] userHandle, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        super(clientDataJSON, clientExtensionsJSON, serverProperty, userVerificationRequired, userPresenceRequired, expectedExtensionIds);
        this.credentialId = credentialId;
        this.signature = signature;
        this.userHandle = userHandle;
        this.authenticatorData = authenticatorData;
    }

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        this(credentialId, clientDataJSON, authenticatorData, signature, null, clientExtensionsJSON, serverProperty, userVerificationRequired, userPresenceRequired, expectedExtensionIds);
    }

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, String clientExtensionsJSON, ServerProperty serverProperty, boolean userVerificationRequired, List<String> expectedExtensionIds) {
        this(credentialId, clientDataJSON, authenticatorData, signature, clientExtensionsJSON, serverProperty, userVerificationRequired, true, CollectionUtil.unmodifiableList(expectedExtensionIds));
    }

    public WebAuthnAuthenticationContext(byte[] credentialId, byte[] clientDataJSON, byte[] authenticatorData, byte[] signature, ServerProperty serverProperty, boolean userVerificationRequired) {
        this(credentialId, clientDataJSON, authenticatorData, signature, null, serverProperty, userVerificationRequired, Collections.emptyList());
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone((byte[])this.authenticatorData);
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public byte[] getUserHandle() {
        return this.userHandle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnAuthenticationContext that = (WebAuthnAuthenticationContext)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature) && Arrays.equals(this.userHandle, that.userHandle);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.signature);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        return result;
    }
}

