/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import com.webauthn4j.data.WebAuthnAuthenticationContext;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.exception.WebAuthnException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.WebAuthnRegisterFactory;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.UriUtils;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.WebAuthnCredentialModelInput;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.WebAuthnAuthenticatorsBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class WebAuthnAuthenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(WebAuthnAuthenticator.class);
    private KeycloakSession session;
    private static final String ERR_LABEL = "web_authn_authentication_error";
    private static final String ERR_DETAIL_LABEL = "web_authn_authentication_error_detail";
    private static final String ERR_NO_AUTHENTICATORS_REGISTERED = "No WebAuthn Authenticator registered.";
    private static final String ERR_WEBAUTHN_API_GET = "Failed to authenticate by the WebAuthn Authenticator";
    private static final String ERR_DIFFERENT_USER_AUTHENTICATED = "First authenticated user is not the one authenticated by the WebAuthn authenticator.";
    private static final String ERR_WEBAUTHN_VERIFICATION_FAIL = "WetAuthn Authentication result is invalid.";
    private static final String ERR_WEBAUTHN_AUTHENTICATED_USER_NOT_FOUND = "Unknown user authenticated by the WebAuthen Authenticator";

    public WebAuthnAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    public void authenticate(AuthenticationFlowContext context) {
        LoginFormsProvider form = context.form();
        DefaultChallenge challenge = new DefaultChallenge();
        String challengeValue = Base64Url.encode((byte[])challenge.getValue());
        context.getAuthenticationSession().setAuthNote("WEBAUTH_CHALLENGE", challengeValue);
        form.setAttribute("challenge", (Object)challengeValue);
        String rpId = context.getRealm().getWebAuthnPolicy().getRpId();
        if (rpId == null || rpId.isEmpty()) {
            rpId = context.getUriInfo().getBaseUri().getHost();
        }
        form.setAttribute("rpId", (Object)rpId);
        UserModel user = context.getUser();
        boolean isUserIdentified = false;
        if (user != null) {
            WebAuthnAuthenticatorsBean authenticators = new WebAuthnAuthenticatorsBean(context.getSession(), context.getRealm(), user);
            if (authenticators.getAuthenticators().isEmpty()) {
                return;
            }
            isUserIdentified = true;
            form.setAttribute("authenticators", (Object)authenticators);
        }
        form.setAttribute("isUserIdentified", (Object)Boolean.toString(isUserIdentified));
        String userVerificationRequirement = context.getRealm().getWebAuthnPolicy().getUserVerificationRequirement();
        form.setAttribute("userVerification", (Object)userVerificationRequirement);
        context.challenge(form.createLoginWebAuthn());
    }

    public void action(AuthenticationFlowContext context) {
        String firstAuthenticatedUserId;
        MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
        String errorMsgFromWebAuthnApi = (String)params.getFirst((Object)"error");
        if (errorMsgFromWebAuthnApi != null && !errorMsgFromWebAuthnApi.isEmpty()) {
            this.setErrorResponse(context, ERR_WEBAUTHN_API_GET, errorMsgFromWebAuthnApi);
            return;
        }
        String baseUrl = UriUtils.getOrigin((URI)context.getUriInfo().getBaseUri());
        String rpId = context.getUriInfo().getBaseUri().getHost();
        Origin origin = new Origin(baseUrl);
        DefaultChallenge challenge = new DefaultChallenge(context.getAuthenticationSession().getAuthNote("WEBAUTH_CHALLENGE"));
        ServerProperty server = new ServerProperty(origin, rpId, (Challenge)challenge, null);
        byte[] credentialId = Base64Url.decode((String)((String)params.getFirst((Object)"credentialId")));
        byte[] clientDataJSON = Base64Url.decode((String)((String)params.getFirst((Object)"clientDataJSON")));
        byte[] authenticatorData = Base64Url.decode((String)((String)params.getFirst((Object)"authenticatorData")));
        byte[] signature = Base64Url.decode((String)((String)params.getFirst((Object)"signature")));
        String userId = (String)params.getFirst((Object)"userHandle");
        boolean isUVFlagChecked = false;
        String userVerificationRequirement = context.getRealm().getWebAuthnPolicy().getUserVerificationRequirement();
        if ("required".equals(userVerificationRequirement)) {
            isUVFlagChecked = true;
        }
        if (userId == null || userId.isEmpty()) {
            userId = context.getUser().getId();
        } else if (context.getUser() != null && (firstAuthenticatedUserId = context.getUser().getId()) != null && !firstAuthenticatedUserId.equals(userId)) {
            context.getEvent().detail("first_authenticated_user_id", firstAuthenticatedUserId).detail("web_authn_authenticator_authenticated_user_id", userId);
            this.setErrorResponse(context, ERR_DIFFERENT_USER_AUTHENTICATED, null);
            return;
        }
        UserModel user = this.session.users().getUserById(userId, context.getRealm());
        WebAuthnAuthenticationContext authenticationContext = new WebAuthnAuthenticationContext(credentialId, clientDataJSON, authenticatorData, signature, server, isUVFlagChecked);
        WebAuthnCredentialModelInput cred = new WebAuthnCredentialModelInput();
        cred.setAuthenticationContext(authenticationContext);
        boolean result = false;
        try {
            result = this.session.userCredentialManager().isValid(context.getRealm(), user, new CredentialInput[]{cred});
        }
        catch (WebAuthnException wae) {
            this.setErrorResponse(context, ERR_WEBAUTHN_VERIFICATION_FAIL, wae.getMessage());
            return;
        }
        String encodedCredentialID = Base64Url.encode((byte[])credentialId);
        if (result) {
            String isUVChecked = Boolean.toString(isUVFlagChecked);
            logger.infov("WebAuthn Authentication successed. isUserVerificationChecked = {0}, PublicKeyCredentialID = {1}", (Object)isUVChecked, (Object)encodedCredentialID);
            context.setUser(user);
            context.getEvent().detail("web_authn_authenticator_user_verification_checked", isUVChecked).detail("public_key_credential_id", encodedCredentialID);
            context.success();
        } else {
            context.getEvent().detail("web_authn_authenticated_user_id", userId).detail("public_key_credential_id", encodedCredentialID);
            this.setErrorResponse(context, ERR_WEBAUTHN_AUTHENTICATED_USER_NOT_FOUND, null);
            context.cancelLogin();
        }
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, "webauthn");
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!user.getRequiredActions().contains("webauthn-register")) {
            user.addRequiredAction("webauthn-register");
        }
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((WebAuthnRegisterFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, "webauthn-register"));
    }

    public void close() {
    }

    private void setErrorResponse(AuthenticationFlowContext context, String errorCase, String errorMessage) {
        Response errorResponse = null;
        switch (errorCase) {
            case "No WebAuthn Authenticator registered.": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase).error("invalid_user_credentials");
                errorResponse = context.form().setError(errorCase, new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
                context.failure(AuthenticationFlowError.INVALID_CREDENTIALS, errorResponse);
                break;
            }
            case "Failed to authenticate by the WebAuthn Authenticator": {
                logger.warnv("error returned from navigator.credentials.get(). {0}", (Object)errorMessage);
                context.getEvent().detail(ERR_LABEL, errorCase).detail(ERR_DETAIL_LABEL, errorMessage).error("not_allowed");
                errorResponse = context.form().setError(errorCase, new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
                context.failure(AuthenticationFlowError.INVALID_USER, errorResponse);
                break;
            }
            case "First authenticated user is not the one authenticated by the WebAuthn authenticator.": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase).error("different_user_authenticated");
                errorResponse = context.form().setError(errorCase, new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
                context.failure(AuthenticationFlowError.USER_CONFLICT, errorResponse);
                break;
            }
            case "WetAuthn Authentication result is invalid.": {
                logger.warnv("WebAuthn API .get() response validation failure. {0}", (Object)errorMessage);
                context.getEvent().detail(ERR_LABEL, errorCase).detail(ERR_DETAIL_LABEL, errorMessage).error("invalid_user_credentials");
                errorResponse = context.form().setError(errorCase, new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
                context.failure(AuthenticationFlowError.INVALID_USER, errorResponse);
                break;
            }
            case "Unknown user authenticated by the WebAuthen Authenticator": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase);
                context.getEvent().error("user_not_found");
                break;
            }
        }
    }
}

