/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.authorization.AuthorizationService;
import org.keycloak.authorization.protection.ProtectionService;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.wellknown.WellKnownProvider;

public class UmaConfiguration
extends OIDCConfigurationRepresentation {
    @JsonProperty(value="resource_registration_endpoint")
    private String resourceRegistrationEndpoint;
    @JsonProperty(value="permission_endpoint")
    private String permissionEndpoint;
    @JsonProperty(value="policy_endpoint")
    private String policyEndpoint;

    public static final UmaConfiguration create(KeycloakSession session) {
        WellKnownProvider oidcProvider = (WellKnownProvider)session.getProvider(WellKnownProvider.class, "openid-configuration");
        OIDCConfigurationRepresentation oidcConfig = (OIDCConfigurationRepresentation)OIDCConfigurationRepresentation.class.cast(oidcProvider.getConfig());
        UmaConfiguration configuration = new UmaConfiguration();
        configuration.setIssuer(oidcConfig.getIssuer());
        configuration.setAuthorizationEndpoint(oidcConfig.getAuthorizationEndpoint());
        configuration.setTokenEndpoint(oidcConfig.getTokenEndpoint());
        configuration.setJwksUri(oidcConfig.getJwksUri());
        configuration.setRegistrationEndpoint(oidcConfig.getRegistrationEndpoint());
        configuration.setScopesSupported(oidcConfig.getScopesSupported());
        configuration.setResponseTypesSupported(oidcConfig.getResponseTypesSupported());
        configuration.setResponseModesSupported(oidcConfig.getResponseModesSupported());
        configuration.setGrantTypesSupported(oidcConfig.getGrantTypesSupported());
        configuration.setTokenEndpointAuthMethodsSupported(oidcConfig.getTokenEndpointAuthMethodsSupported());
        configuration.setTokenEndpointAuthSigningAlgValuesSupported(oidcConfig.getTokenEndpointAuthSigningAlgValuesSupported());
        configuration.setTokenIntrospectionEndpoint(oidcConfig.getTokenIntrospectionEndpoint());
        configuration.setLogoutEndpoint(oidcConfig.getLogoutEndpoint());
        UriBuilder uriBuilder = session.getContext().getUri().getBaseUriBuilder();
        RealmModel realm = session.getContext().getRealm();
        configuration.setPermissionEndpoint(uriBuilder.clone().path(RealmsResource.class).path(RealmsResource.class, "getAuthorizationService").path(AuthorizationService.class, "getProtectionService").path(ProtectionService.class, "permission").build(new Object[]{realm.getName()}).toString());
        configuration.setResourceRegistrationEndpoint(uriBuilder.clone().path(RealmsResource.class).path(RealmsResource.class, "getAuthorizationService").path(AuthorizationService.class, "getProtectionService").path(ProtectionService.class, "resource").build(new Object[]{realm.getName()}).toString());
        configuration.setPolicyEndpoint(uriBuilder.clone().path(RealmsResource.class).path(RealmsResource.class, "getAuthorizationService").path(AuthorizationService.class, "getProtectionService").path(ProtectionService.class, "policy").build(new Object[]{realm.getName()}).toString());
        return configuration;
    }

    public String getResourceRegistrationEndpoint() {
        return this.resourceRegistrationEndpoint;
    }

    void setResourceRegistrationEndpoint(String resourceRegistrationEndpoint) {
        this.resourceRegistrationEndpoint = resourceRegistrationEndpoint;
    }

    public String getPermissionEndpoint() {
        return this.permissionEndpoint;
    }

    void setPermissionEndpoint(String permissionEndpoint) {
        this.permissionEndpoint = permissionEndpoint;
    }

    public String getPolicyEndpoint() {
        return this.policyEndpoint;
    }

    void setPolicyEndpoint(String policyEndpoint) {
        this.policyEndpoint = policyEndpoint;
    }
}

