/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointQueryStringParser;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestObjectParser;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;

public class AuthorizationEndpointRequestParserProcessor {
    public static AuthorizationEndpointRequest parseRequest(EventBuilder event, KeycloakSession session, ClientModel client, MultivaluedMap<String, String> requestParams) {
        try {
            AuthorizationEndpointRequest request = new AuthorizationEndpointRequest();
            new AuthzEndpointQueryStringParser(requestParams).parseRequest(request);
            String requestParam = (String)requestParams.getFirst((Object)"request");
            String requestUriParam = (String)requestParams.getFirst((Object)"request_uri");
            if (requestParam != null && requestUriParam != null) {
                throw new RuntimeException("Illegal to use both 'request' and 'request_uri' parameters together");
            }
            String requestObjectRequired = OIDCAdvancedConfigWrapper.fromClientModel(client).getRequestObjectRequired();
            if ("request or request_uri".equals(requestObjectRequired) && requestParam == null && requestUriParam == null) {
                throw new RuntimeException("Client is required to use 'request' or 'request_uri' parameter.");
            }
            if ("request only".equals(requestObjectRequired) && requestParam == null) {
                throw new RuntimeException("Client is required to use 'request' parameter.");
            }
            if ("request_uri only".equals(requestObjectRequired) && requestUriParam == null) {
                throw new RuntimeException("Client is required to use 'request_uri' parameter.");
            }
            if (requestParam != null) {
                new AuthzEndpointRequestObjectParser(session, requestParam, client).parseRequest(request);
            } else if (requestUriParam != null) {
                try (InputStream is = ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).get(requestUriParam);){
                    String retrievedRequest = StreamUtil.readString((InputStream)is);
                    new AuthzEndpointRequestObjectParser(session, retrievedRequest, client).parseRequest(request);
                }
            }
            return request;
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.invalidRequest(e);
            event.error("invalid_request");
            throw new ErrorPageException(session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
    }
}

