/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.ClaimResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.util.JsonSerialization;

public class ApplicationResource {
    protected static final Logger logger = Logger.getLogger(ApplicationResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    protected ApplicationModel application;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakApplication keycloak;

    protected KeycloakApplication getKeycloakApplication() {
        return this.keycloak;
    }

    public ApplicationResource(RealmModel realm, RealmAuth auth, ApplicationModel applicationModel, KeycloakSession session) {
        this.realm = realm;
        this.auth = auth;
        this.application = applicationModel;
        this.session = session;
        auth.init(RealmAuth.Resource.APPLICATION);
    }

    @Path(value="claims")
    public ClaimResource getClaimResource() {
        return new ClaimResource((ClientModel)this.application, this.auth);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ApplicationRepresentation rep) {
        this.auth.requireManage();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        try {
            RepresentationToModel.updateApplication((ApplicationRepresentation)rep, (ApplicationModel)this.application);
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Application " + rep.getName() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ApplicationRepresentation getApplication() {
        this.auth.requireView();
        return ModelToRepresentation.toRepresentation((ApplicationModel)this.application);
    }

    @GET
    @NoCache
    @Path(value="installation/json")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        this.auth.requireView();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        ApplicationManager.InstallationAdapterConfig rep = applicationManager.toInstallationRepresentation(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @GET
    @NoCache
    @Path(value="installation/jboss")
    @Produces(value={"text/plain"})
    public String getJBossInstallation() throws IOException {
        this.auth.requireView();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toJBossSubsystemConfig(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
    }

    @DELETE
    @NoCache
    public void deleteApplication() {
        this.auth.requireManage();
        new ApplicationManager(new RealmManager(this.session)).removeApplication(this.realm, this.application);
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.requireManage();
        logger.debug((Object)"regenerateSecret");
        UserCredentialModel cred = KeycloakModelUtils.generateSecret((ClientModel)this.application);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation((UserCredentialModel)cred);
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.requireView();
        logger.debug((Object)"getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.application.getSecret());
        if (model == null) {
            throw new NotFoundException("Application does not have a secret");
        }
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.auth, (ClientModel)this.application, this.session);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.realm, this.auth, (RoleContainerModel)this.application);
    }

    @Path(value="allowed-origins")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins() {
        this.auth.requireView();
        return this.application.getWebOrigins();
    }

    @Path(value="allowed-origins")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        this.application.setWebOrigins(allowedOrigins);
    }

    @Path(value="allowed-origins")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        for (String origin : allowedOrigins) {
            this.application.removeWebOrigin(origin);
        }
    }

    @Path(value="push-revocation")
    @POST
    public void pushRevocation() {
        this.auth.requireManage();
        new ResourceAdminManager().pushApplicationRevocationPolicy(this.uriInfo.getRequestUri(), this.realm, this.application);
    }

    @Path(value="session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public SessionStats getSessionStats(@QueryParam(value="users") @DefaultValue(value="false") boolean users) {
        logger.info((Object)"session-stats");
        this.auth.requireView();
        if (this.application.getManagementUrl() == null || this.application.getManagementUrl().trim().equals("")) {
            logger.info((Object)"sending empty stats");
            SessionStats stats = new SessionStats();
            if (users) {
                stats.setUsers(new HashMap());
            }
            return stats;
        }
        SessionStats stats = new ResourceAdminManager().getSessionStats(this.uriInfo.getRequestUri(), this.session, this.realm, this.application, users);
        if (stats == null) {
            logger.info((Object)"app returned null stats");
        } else {
            logger.info((Object)("activeUsers: " + stats.getActiveUsers()));
            logger.info((Object)("activeSessions: " + stats.getActiveSessions()));
        }
        return stats;
    }

    @Path(value="session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Integer> getApplicationSessionCount() {
        this.auth.requireView();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", this.session.sessions().getActiveUserSessions(this.application.getRealm(), (ClientModel)this.application));
        return map;
    }

    @Path(value="user-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.requireView();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel userSession : this.session.sessions().getUserSessions(this.application.getRealm(), (ClientModel)this.application, firstResult.intValue(), maxResults.intValue())) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="logout-all")
    @POST
    public void logoutAll() {
        this.auth.requireManage();
        new ResourceAdminManager().logoutApplication(this.uriInfo.getRequestUri(), this.realm, this.application, null, null);
    }

    @Path(value="logout-user/{username}")
    @POST
    public void logout(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserByUsername(username, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        new ResourceAdminManager().logoutApplication(this.uriInfo.getRequestUri(), this.realm, this.application, user.getId(), null);
    }
}

