/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.RealmImporter;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;

public class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    private ClientConnection connection;
    private KeycloakSession session;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public String getContextPath() {
        KeycloakApplication app = this.getContextObject(KeycloakApplication.class);
        return app.getContextPath();
    }

    public UriInfo getUri() {
        return this.getContextObject(UriInfo.class);
    }

    public HttpHeaders getRequestHeaders() {
        return this.getContextObject(HttpHeaders.class);
    }

    public <T> T getContextObject(Class<T> clazz) {
        return (T)ResteasyProviderFactory.getContextData(clazz);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ClientConnection connection) {
        this.connection = connection;
    }

    public RealmImporter getRealmManager() {
        RealmManager manager = new RealmManager(this.session);
        manager.setContextPath(this.getContextPath());
        return manager;
    }
}

