/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.validation.Validation;

public class UpdatePassword
implements RequiredActionProvider,
RequiredActionFactory {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public void evaluateTriggers(RequiredActionContext context) {
        int daysToExpirePassword = context.getRealm().getPasswordPolicy().getDaysToExpirePassword();
        if (daysToExpirePassword != -1) {
            for (UserCredentialValueModel entity : context.getUser().getCredentialsDirectly()) {
                long timeToExpire;
                if (!entity.getType().equals("password")) continue;
                if (entity.getCreatedDate() == null) {
                    context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    logger.debug("User is required to update password");
                    break;
                }
                long timeElapsed = Time.toMillis((int)Time.currentTime()) - entity.getCreatedDate();
                if (timeElapsed <= (timeToExpire = TimeUnit.DAYS.toMillis(daysToExpirePassword))) break;
                context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                logger.debug("User is required to update password");
                break;
            }
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        event.event(EventType.UPDATE_PASSWORD);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        EventBuilder errorEvent = event.clone().event(EventType.UPDATE_PASSWORD_ERROR).client(context.getClientSession().getClient()).user(context.getClientSession().getUserSession().getUser());
        if (Validation.isBlank(passwordNew)) {
            Response challenge = context.form().setError("missingPasswordMessage", new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_missing");
            return;
        }
        if (!passwordNew.equals(passwordConfirm)) {
            Response challenge = context.form().setError("notMatchPasswordMessage", new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_confirm_error");
            return;
        }
        try {
            context.getSession().users().updateCredential(context.getRealm(), context.getUser(), UserCredentialModel.password((String)passwordNew));
            context.success();
        }
        catch (ModelException me) {
            errorEvent.detail("reason", me.getMessage()).error("password_rejected");
            Response challenge = context.form().setError(me.getMessage(), me.getParameters()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
        catch (Exception ape) {
            errorEvent.detail("reason", ape.getMessage()).error("password_rejected");
            Response challenge = context.form().setError(ape.getMessage(), new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Password";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }
}

