/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.KeycloakSession;
import org.keycloak.util.JsonSerialization;

public class JWKSUtils {
    public static JSONWebKeySet sendJwksRequest(KeycloakSession session, String jwksURI) throws IOException {
        InputStream is = ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).get(jwksURI);
        String keySetString = StreamUtil.readString((InputStream)is);
        return (JSONWebKeySet)JsonSerialization.readValue((String)keySetString, JSONWebKeySet.class);
    }

    public static PublicKey getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create((JWK)jwk);
            if (!parser.getJwk().getPublicKeyUse().equals(requestedUse.asString()) || !parser.isAlgorithmSupported(jwk.getKeyType())) continue;
            return parser.toPublicKey();
        }
        return null;
    }
}

