/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.Failure;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientRegistrationTrustedHostModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationHostUtils;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;

public class ClientRegistrationAuth {
    private KeycloakSession session;
    private EventBuilder event;
    private RealmModel realm;
    private JsonWebToken jwt;
    private ClientInitialAccessModel initialAccessModel;
    private ClientRegistrationTrustedHostModel trustedHostModel;

    public ClientRegistrationAuth(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
    }

    private void init() {
        this.realm = this.session.getContext().getRealm();
        UriInfo uri = this.session.getContext().getUri();
        String authorizationHeader = (String)this.session.getContext().getRequestHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader == null) {
            this.trustedHostModel = ClientRegistrationHostUtils.getTrustedHost(this.session.getContext().getConnection().getRemoteAddr(), this.session, this.realm);
            return;
        }
        String[] split = authorizationHeader.split(" ");
        if (!split[0].equalsIgnoreCase("bearer")) {
            return;
        }
        ClientRegistrationTokenUtils.TokenVerification tokenVerification = ClientRegistrationTokenUtils.verifyToken(this.realm, uri, split[1]);
        if (tokenVerification.getError() != null) {
            throw this.unauthorized(tokenVerification.getError().getMessage());
        }
        this.jwt = tokenVerification.getJwt();
        if (this.isInitialAccessToken()) {
            this.initialAccessModel = this.session.sessions().getClientInitialAccessModel(this.session.getContext().getRealm(), this.jwt.getId());
            if (this.initialAccessModel == null) {
                throw this.unauthorized("Initial Access Token not found");
            }
        }
    }

    public boolean isRegistrationHostTrusted() {
        return this.trustedHostModel != null;
    }

    private boolean isBearerToken() {
        return this.jwt != null && "Bearer".equals(this.jwt.getType());
    }

    public boolean isInitialAccessToken() {
        return this.jwt != null && "InitialAccessToken".equals(this.jwt.getType());
    }

    public boolean isRegistrationAccessToken() {
        return this.jwt != null && "RegistrationAccessToken".equals(this.jwt.getType());
    }

    public void requireCreate() {
        this.init();
        if (this.isRegistrationHostTrusted()) {
            return;
        }
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.CREATE_CLIENT)) {
                return;
            }
            throw this.forbidden();
        }
        if (this.isInitialAccessToken() && this.initialAccessModel.getRemainingCount() > 0 && (this.initialAccessModel.getExpiration() == 0 || this.initialAccessModel.getTimestamp() + this.initialAccessModel.getExpiration() > Time.currentTime())) {
            return;
        }
        throw this.unauthorized("Not authenticated to view client. Host not trusted and Token is missing or invalid.");
    }

    public void requireView(ClientModel client) {
        this.init();
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS)) {
                if (client == null) {
                    throw this.notFound();
                }
                return;
            }
            throw this.forbidden();
        }
        if (this.isRegistrationAccessToken()) {
            if (client.getRegistrationToken() != null && client.getRegistrationToken().equals(this.jwt.getId())) {
                return;
            }
        } else {
            if (this.isInitialAccessToken()) {
                throw this.unauthorized("Not initial access token");
            }
            if (this.authenticateClient(client)) {
                return;
            }
        }
        throw this.unauthorized("Not authorized to view client. Missing or invalid token or bad client credentials.");
    }

    public void requireUpdate(ClientModel client) {
        this.init();
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS)) {
                if (client == null) {
                    throw this.notFound();
                }
                return;
            }
            throw this.forbidden();
        }
        if (this.isRegistrationAccessToken() && client.getRegistrationToken() != null && client != null && client.getRegistrationToken().equals(this.jwt.getId())) {
            return;
        }
        throw this.unauthorized("Not authorized to update client. Missing or invalid token.");
    }

    public ClientInitialAccessModel getInitialAccessModel() {
        return this.initialAccessModel;
    }

    public ClientRegistrationTrustedHostModel getTrustedHostModel() {
        return this.trustedHostModel;
    }

    private boolean hasRole(String ... role) {
        try {
            Map otherClaims = this.jwt.getOtherClaims();
            if (otherClaims != null) {
                Map resourceAccess = (Map)this.jwt.getOtherClaims().get("resource_access");
                if (resourceAccess == null) {
                    return false;
                }
                List roles = null;
                Map map = this.realm.getName().equals(Config.getAdminRealm()) ? (Map)resourceAccess.get(this.realm.getMasterAdminClient().getClientId()) : (Map)resourceAccess.get("realm-management");
                if (map != null) {
                    roles = (List)map.get("roles");
                }
                if (roles == null) {
                    return false;
                }
                for (String r : role) {
                    if (!roles.contains(r)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean authenticateClient(ClientModel client) {
        if (client.isPublicClient()) {
            return true;
        }
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(this.session, this.event);
        Response response = processor.authenticateClient();
        if (response != null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("Failed to authenticate client");
        }
        ClientModel authClient = processor.getClient();
        if (authClient == null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("No client authenticated");
        }
        if (!authClient.getClientId().equals(client.getClientId())) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("Different client authenticated");
        }
        return true;
    }

    private Failure unauthorized(String errorDescription) {
        this.event.detail("reason", errorDescription).error("invalid_token");
        throw new ErrorResponseException("invalid_token", errorDescription, Response.Status.UNAUTHORIZED);
    }

    private Failure forbidden() {
        this.event.error("not_allowed");
        throw new ErrorResponseException("insufficient_scope", "Forbidden", Response.Status.FORBIDDEN);
    }

    private Failure notFound() {
        this.event.error("client_not_found");
        throw new ErrorResponseException("invalid_request", "Client not found", Response.Status.NOT_FOUND);
    }
}

