/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientRegistrationTrustedHostModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class ClientRegistrationHostUtils {
    private static final Logger logger = Logger.getLogger(ClientRegistrationHostUtils.class);

    public static ClientRegistrationTrustedHostModel getTrustedHost(String hostAddress, KeycloakSession session, RealmModel realm) {
        logger.debugf("Verifying remote host : %s", (Object)hostAddress);
        List trustedHosts = session.sessions().listClientRegistrationTrustedHosts(realm);
        for (ClientRegistrationTrustedHostModel realmTrustedHost : trustedHosts) {
            try {
                if (realmTrustedHost.getRemainingCount() <= 0) continue;
                String realmHostIPAddress = InetAddress.getByName(realmTrustedHost.getHostName()).getHostAddress();
                logger.debugf("Trying host '%s' of address '%s'", (Object)realmTrustedHost.getHostName(), (Object)realmHostIPAddress);
                if (!realmHostIPAddress.equals(hostAddress)) continue;
                logger.debugf("Successfully verified host : %s", (Object)realmTrustedHost.getHostName());
                return realmTrustedHost;
            }
            catch (UnknownHostException uhe) {
                logger.debugf("Unknown host from realm configuration: %s", (Object)realmTrustedHost.getHostName());
            }
        }
        logger.debugf("Failed to verify remote host : %s", (Object)hostAddress);
        return null;
    }
}

