/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.common.Version;

@Path(value="/js")
public class JsResource {
    @GET
    @Path(value="/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakJs() {
        return this.getJs("keycloak.js");
    }

    @GET
    @Path(value="/{version}/keycloak.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getKeycloakJs();
    }

    @GET
    @Path(value="/keycloak.min.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakMinJs() {
        return this.getJs("keycloak.min.js");
    }

    @GET
    @Path(value="/{version}/keycloak.min.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakMinJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getKeycloakMinJs();
    }

    @GET
    @Path(value="/keycloak-authz.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakAuthzJs() {
        return this.getJs("keycloak-authz.js");
    }

    @GET
    @Path(value="/{version}/keycloak-authz.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakAuthzJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getKeycloakAuthzJs();
    }

    @GET
    @Path(value="/keycloak-authz.min.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakAuthzMinJs() {
        return this.getJs("keycloak-authz.min.js");
    }

    @GET
    @Path(value="/{version}/keycloak-authz.min.js")
    @Produces(value={"text/javascript"})
    public Response getKeycloakAuthzMinJsWithVersion(@PathParam(value="version") String version) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.getKeycloakAuthzMinJs();
    }

    private Response getJs(String name) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
        if (inputStream != null) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)inputStream).type("text/javascript").cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

