/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientRegistrationTrustedHostModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientRegistrationTrustedHostRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientRegistrationTrustedHostResource {
    private final RealmAuth auth;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;

    public ClientRegistrationTrustedHostResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_REGISTRATION_TRUSTED_HOST_MODEL);
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ClientRegistrationTrustedHostRepresentation config) {
        this.auth.requireManage();
        if (config.getHostName() == null) {
            return ErrorResponse.error("hostName not provided in config", Response.Status.BAD_REQUEST);
        }
        int count = config.getCount() != null ? config.getCount() : 1;
        try {
            ClientRegistrationTrustedHostModel clientRegTrustedHostModel = this.session.sessions().createClientRegistrationTrustedHostModel(this.realm, config.getHostName(), count);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, clientRegTrustedHostModel.getHostName()).representation(config).success();
            return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(clientRegTrustedHostModel.getHostName()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException mde) {
            return ErrorResponse.exists(mde.getMessage());
        }
    }

    @PUT
    @Path(value="{hostname}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="hostname") String hostName, ClientRegistrationTrustedHostRepresentation config) {
        this.auth.requireManage();
        if (config.getHostName() == null || !hostName.equals(config.getHostName())) {
            return ErrorResponse.error("hostName not provided in config or not compatible", Response.Status.BAD_REQUEST);
        }
        if (config.getCount() == null) {
            return ErrorResponse.error("count needs to be available", Response.Status.BAD_REQUEST);
        }
        if (config.getRemainingCount() != null && config.getRemainingCount() > config.getCount()) {
            return ErrorResponse.error("remainingCount can't be bigger than count", Response.Status.BAD_REQUEST);
        }
        ClientRegistrationTrustedHostModel hostModel = this.session.sessions().getClientRegistrationTrustedHostModel(this.realm, config.getHostName());
        if (hostModel == null) {
            return ErrorResponse.error("hostName record not found", Response.Status.NOT_FOUND);
        }
        hostModel.setCount(config.getCount().intValue());
        hostModel.setRemainingCount(config.getRemainingCount().intValue());
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(config).success();
        return Response.noContent().build();
    }

    @GET
    @Path(value="{hostname}")
    @Produces(value={"application/json"})
    public ClientRegistrationTrustedHostRepresentation getConfig(@PathParam(value="hostname") String hostName) {
        this.auth.requireView();
        ClientRegistrationTrustedHostModel hostModel = this.session.sessions().getClientRegistrationTrustedHostModel(this.realm, hostName);
        if (hostModel == null) {
            throw new NotFoundException("hostName record not found");
        }
        return this.wrap(hostModel);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ClientRegistrationTrustedHostRepresentation> list() {
        this.auth.requireView();
        List models = this.session.sessions().listClientRegistrationTrustedHosts(this.realm);
        LinkedList<ClientRegistrationTrustedHostRepresentation> reps = new LinkedList<ClientRegistrationTrustedHostRepresentation>();
        for (ClientRegistrationTrustedHostModel m : models) {
            ClientRegistrationTrustedHostRepresentation r = this.wrap(m);
            reps.add(r);
        }
        return reps;
    }

    @DELETE
    @Path(value="{hostname}")
    public void delete(@PathParam(value="hostname") String hostName) {
        this.auth.requireManage();
        this.session.sessions().removeClientRegistrationTrustedHostModel(this.realm, hostName);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    private ClientRegistrationTrustedHostRepresentation wrap(ClientRegistrationTrustedHostModel model) {
        return ClientRegistrationTrustedHostRepresentation.create((String)model.getHostName(), (int)model.getCount(), (int)model.getRemainingCount());
    }
}

