/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public class JBossJtaTransactionManagerLookup
implements JtaTransactionManagerLookup {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private TransactionManager tm;

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void init(Config.Scope config) {
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:jboss/TransactionManager");
            if (this.tm == null) {
                logger.debug("Could not locate TransactionManager");
            }
        }
        catch (NamingException e) {
            logger.debug("Could not load TransactionManager", e);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "jboss";
    }
}

