/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;

public class PasswordCredentialProvider
implements CredentialProvider,
CredentialInputValidator,
CredentialInputUpdater,
OnUserCache {
    public static final String PASSWORD_CACHE_KEY = PasswordCredentialProvider.class.getName() + "." + "password";
    private static final Logger logger = Logger.getLogger(PasswordCredentialProvider.class);
    protected KeycloakSession session;

    public PasswordCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public CredentialModel getPassword(RealmModel realm, UserModel user) {
        List passwords = null;
        if (user instanceof CachedUserModel) {
            CachedUserModel cached = (CachedUserModel)user;
            passwords = (List)cached.getCachedWith().get(PASSWORD_CACHE_KEY);
        } else {
            passwords = this.getCredentialStore().getStoredCredentialsByType(realm, user, "password");
        }
        if (passwords == null || passwords.isEmpty()) {
            return null;
        }
        return (CredentialModel)passwords.get(0);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType())) {
            return false;
        }
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        PasswordPolicy policy = realm.getPasswordPolicy();
        PolicyError error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, cred.getValue());
        if (error != null) {
            throw new ModelException(error.getMessage(), error.getParameters());
        }
        PasswordHashProvider hash = this.getHashProvider(policy);
        if (hash == null) {
            return false;
        }
        CredentialModel oldPassword = this.getPassword(realm, user);
        this.expirePassword(realm, user, policy);
        CredentialModel newPassword = new CredentialModel();
        newPassword.setType("password");
        long createdDate = Time.currentTimeMillis();
        newPassword.setCreatedDate(Long.valueOf(createdDate));
        hash.encode(cred.getValue(), policy, newPassword);
        this.getCredentialStore().createCredential(realm, user, newPassword);
        this.session.getUserCache().evict(realm, user);
        return true;
    }

    protected void expirePassword(RealmModel realm, UserModel user, PasswordPolicy policy) {
        CredentialModel oldPassword = this.getPassword(realm, user);
        if (oldPassword == null) {
            return;
        }
        int expiredPasswordsPolicyValue = policy.getExpiredPasswords();
        if (expiredPasswordsPolicyValue > -1) {
            List list = this.getCredentialStore().getStoredCredentialsByType(realm, user, "password-history");
            LinkedList history = new LinkedList();
            history.addAll(list);
            if (history.size() + 1 >= expiredPasswordsPolicyValue) {
                Collections.sort(history, new Comparator<CredentialModel>(){

                    @Override
                    public int compare(CredentialModel o1, CredentialModel o2) {
                        long o2Date;
                        long o1Date = o1.getCreatedDate() == null ? 0L : o1.getCreatedDate();
                        long l = o2Date = o2.getCreatedDate() == null ? 0L : o2.getCreatedDate();
                        if (o1Date > o2Date) {
                            return 1;
                        }
                        if (o1Date < o2Date) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (int i = 0; i < history.size() + 2 - expiredPasswordsPolicyValue; ++i) {
                    this.getCredentialStore().removeStoredCredential(realm, user, ((CredentialModel)history.get(i)).getId());
                }
            }
            oldPassword.setType("password-history");
            this.getCredentialStore().updateCredential(realm, user, oldPassword);
        } else {
            this.session.userCredentialManager().removeStoredCredential(realm, user, oldPassword.getId());
        }
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            logger.warnv("Realm PasswordPolicy PasswordHashProvider {0} not found", (Object)policy.getHashAlgorithm());
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, "pbkdf2");
        }
        return hash;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return;
        }
        PasswordPolicy policy = realm.getPasswordPolicy();
        this.expirePassword(realm, user, policy);
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("password");
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getPassword(realm, user) != null;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        if (cred.getValue() == null) {
            logger.debugv("Input password was null for user {0} ", (Object)user.getUsername());
            return false;
        }
        CredentialModel password = this.getPassword(realm, user);
        if (password == null) {
            logger.debugv("No password cached or stored for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, password.getAlgorithm());
        if (hash == null) {
            logger.debugv("PasswordHashProvider {0} not found for user {1} ", (Object)password.getAlgorithm(), (Object)user.getUsername());
            return false;
        }
        if (!hash.verify(cred.getValue(), password)) {
            logger.debugv("Failed password validation for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordPolicy policy = realm.getPasswordPolicy();
        if (policy == null) {
            return true;
        }
        hash = this.getHashProvider(policy);
        if (hash == null) {
            return true;
        }
        if (hash.policyCheck(policy, password)) {
            return true;
        }
        hash.encode(cred.getValue(), policy, password);
        this.getCredentialStore().updateCredential(realm, user, password);
        this.session.getUserCache().evict(realm, user);
        return true;
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List passwords = this.getCredentialStore().getStoredCredentialsByType(realm, (UserModel)user, "password");
        if (passwords != null) {
            user.getCachedWith().put(PASSWORD_CACHE_KEY, passwords);
        }
    }
}

