/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.authorization.representation.AuthorizationRequest;
import org.keycloak.authorization.authorization.representation.AuthorizationResponse;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.protection.permission.PermissionTicket;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.Cors;

public class AuthorizationTokenService {
    protected static final Logger logger = Logger.getLogger(AuthorizationTokenService.class);
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest httpRequest;
    @Context
    private KeycloakSession session;

    public AuthorizationTokenService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @OPTIONS
    public Response authorizepPreFlight() {
        return Cors.add(this.httpRequest, Response.ok()).auth().preflight().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authorize(AuthorizationRequest authorizationRequest) {
        KeycloakEvaluationContext evaluationContext = new KeycloakEvaluationContext(this.authorization.getKeycloakSession());
        KeycloakIdentity identity = (KeycloakIdentity)evaluationContext.getIdentity();
        if (!identity.hasRealmRole("uma_authorization")) {
            throw new ErrorResponseException("invalid_scope", "Requires uma_authorization scope.", Response.Status.FORBIDDEN);
        }
        if (authorizationRequest == null) {
            throw new ErrorResponseException("invalid_request", "Invalid authorization request.", Response.Status.BAD_REQUEST);
        }
        try {
            PermissionTicket ticket = this.verifyPermissionTicket(authorizationRequest);
            ResourceServer resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findById(ticket.getResourceServerId());
            if (resourceServer == null) {
                throw new ErrorResponseException("invalid_request", "Client does not support permissions", Response.Status.FORBIDDEN);
            }
            List result = this.authorization.evaluators().from(this.createPermissions(ticket, authorizationRequest, this.authorization), (EvaluationContext)evaluationContext).evaluate();
            List<Permission> entitlements = Permissions.permits(result, authorizationRequest.getMetadata(), this.authorization, resourceServer);
            if (!entitlements.isEmpty()) {
                AuthorizationResponse response = new AuthorizationResponse(this.createRequestingPartyToken(entitlements, identity.getAccessToken(), resourceServer));
                return Cors.add(this.httpRequest, Response.status((Response.Status)Response.Status.CREATED).entity((Object)response)).allowedOrigins(identity.getAccessToken()).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
            }
        }
        catch (Exception cause) {
            logger.error((Object)"Failed to evaluate permissions", (Throwable)cause);
            throw new ErrorResponseException("server_error", "Error while evaluating permissions.", Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("error", "not_authorized");
        return Cors.add(this.httpRequest, Response.status((Response.Status)Response.Status.FORBIDDEN).entity(error)).allowedOrigins(identity.getAccessToken()).exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private List<ResourcePermission> createPermissions(PermissionTicket ticket, AuthorizationRequest request, AuthorizationProvider authorization) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer resourceServer = authorization.getStoreFactory().getResourceServerStore().findById(ticket.getResourceServerId());
        if (resourceServer == null) {
            throw new ErrorResponseException("invalid_request", "Client does not support permissions", Response.Status.FORBIDDEN);
        }
        HashMap permissionsToEvaluate = new HashMap();
        ticket.getResources().forEach(requestedResource -> {
            Resource resource = requestedResource.getId() != null ? storeFactory.getResourceStore().findById(requestedResource.getId(), ticket.getResourceServerId()) : storeFactory.getResourceStore().findByName(requestedResource.getName(), ticket.getResourceServerId());
            if (resource == null && (requestedResource.getScopes() == null || requestedResource.getScopes().isEmpty())) {
                throw new ErrorResponseException("invalid_resource", "Resource with id [" + requestedResource.getId() + "] or name [" + requestedResource.getName() + "] does not exist.", Response.Status.FORBIDDEN);
            }
            Set requestedScopes = requestedResource.getScopes();
            Set collect = requestedScopes.stream().map(ScopeRepresentation::getName).collect(Collectors.toSet());
            if (resource != null) {
                permissionsToEvaluate.put(resource.getId(), collect);
            } else {
                ResourceStore resourceStore = authorization.getStoreFactory().getResourceStore();
                ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
                ArrayList resources = new ArrayList();
                resources.addAll(resourceStore.findByScope(requestedScopes.stream().map(scopeRepresentation -> {
                    Scope scope = scopeStore.findByName(scopeRepresentation.getName(), ticket.getResourceServerId());
                    if (scope == null) {
                        return null;
                    }
                    return scope.getId();
                }).filter(s -> s != null).collect(Collectors.toList()), ticket.getResourceServerId()));
                for (Resource resource1 : resources) {
                    permissionsToEvaluate.put(resource1.getId(), collect);
                }
                permissionsToEvaluate.put("$KC_SCOPE_PERMISSION", collect);
            }
        });
        String rpt = request.getRpt();
        if (rpt != null && !"".equals(rpt)) {
            List permissions;
            AccessToken.Authorization authorizationData;
            AccessToken requestingPartyToken;
            if (!Tokens.verifySignature(this.session, this.getRealm(), rpt)) {
                throw new ErrorResponseException("invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            try {
                requestingPartyToken = (AccessToken)new JWSInput(rpt).readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new ErrorResponseException("invalid_rpt", "Invalid RPT", Response.Status.FORBIDDEN);
            }
            if (requestingPartyToken.isActive() && (authorizationData = requestingPartyToken.getAuthorization()) != null && (permissions = authorizationData.getPermissions()) != null) {
                permissions.forEach(permission -> {
                    Resource resourcePermission = storeFactory.getResourceStore().findById(permission.getResourceSetId(), ticket.getResourceServerId());
                    if (resourcePermission != null) {
                        Set scopePermission;
                        HashSet scopes = (HashSet)permissionsToEvaluate.get(resourcePermission.getId());
                        if (scopes == null) {
                            scopes = new HashSet();
                            permissionsToEvaluate.put(resourcePermission.getId(), scopes);
                        }
                        if ((scopePermission = permission.getScopes()) != null) {
                            scopes.addAll(scopePermission);
                        }
                    }
                });
            }
        }
        return permissionsToEvaluate.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            if ("$KC_SCOPE_PERMISSION".equals(key)) {
                ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
                List scopes = ((Set)entry.getValue()).stream().map(scopeName -> scopeStore.findByName(scopeName, resourceServer.getId())).filter(scope -> Objects.nonNull(scope)).collect(Collectors.toList());
                return Arrays.asList(new ResourcePermission(null, scopes, resourceServer)).stream();
            }
            Resource entryResource = storeFactory.getResourceStore().findById(key, resourceServer.getId());
            return Permissions.createResourcePermissions(entryResource, (Set)entry.getValue(), authorization).stream();
        }).collect(Collectors.toList());
    }

    private RealmModel getRealm() {
        return this.authorization.getKeycloakSession().getContext().getRealm();
    }

    private String createRequestingPartyToken(List<Permission> permissions, AccessToken accessToken, ResourceServer resourceServer) {
        AccessToken.Authorization authorization = new AccessToken.Authorization();
        authorization.setPermissions(permissions);
        accessToken.setAuthorization(authorization);
        ClientModel clientModel = this.authorization.getRealm().getClientById(resourceServer.getId());
        if (!accessToken.hasAudience(clientModel.getClientId())) {
            accessToken.audience(new String[]{clientModel.getClientId()});
        }
        return new TokenManager().encodeToken(this.session, this.getRealm(), accessToken);
    }

    private PermissionTicket verifyPermissionTicket(AuthorizationRequest request) {
        String ticketString = request.getTicket();
        if (ticketString == null || !Tokens.verifySignature(this.session, this.getRealm(), ticketString)) {
            throw new ErrorResponseException("invalid_ticket", "Ticket verification failed", Response.Status.FORBIDDEN);
        }
        try {
            PermissionTicket ticket = (PermissionTicket)((Object)new JWSInput(ticketString).readJsonContent(PermissionTicket.class));
            if (!ticket.isActive()) {
                throw new ErrorResponseException("invalid_ticket", "Invalid permission ticket.", Response.Status.FORBIDDEN);
            }
            return ticket;
        }
        catch (JWSInputException e) {
            throw new ErrorResponseException("invalid_ticket", "Could not parse permission ticket.", Response.Status.FORBIDDEN);
        }
    }
}

