/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.keys.AbstractRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.ImportedRsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedRsaKeyProviderFactory
extends AbstractRsaKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedRsaKeyProviderFactory.class);
    public static final String ID = "rsa-generated";
    private static final String HELP_TEXT = "Generates RSA keys and creates a self-signed certificate";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractRsaKeyProviderFactory.configurationBuilder().property(Attributes.KEY_SIZE_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        return new ImportedRsaKeyProvider(session.getContext().getRealm(), model);
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, realm, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(Attributes.KEY_SIZE_PROPERTY, false);
        int size = model.get("keySize", 2048);
        if (!model.contains("privateKey") || !model.contains("certificate")) {
            this.generateKeys(realm, model, size);
            logger.debugv("Generated keys for {0}", (Object)realm.getName());
        } else {
            PrivateKey privateKey = PemUtils.decodePrivateKey((String)model.get("privateKey"));
            int currentSize = ((RSAPrivateKey)privateKey).getModulus().bitLength();
            if (currentSize != size) {
                this.generateKeys(realm, model, size);
                logger.debugv("Key size changed, generating new keys for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateKeys(RealmModel realm, ComponentModel model, int size) {
        KeyPair keyPair;
        try {
            keyPair = KeyUtils.generateRsaKeyPair((int)size);
            model.put("privateKey", PemUtils.encodeKey((Key)keyPair.getPrivate()));
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate keys", t);
        }
        this.generateCertificate(realm, model, keyPair);
    }

    private void generateCertificate(RealmModel realm, ComponentModel model, KeyPair keyPair) {
        try {
            X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
            model.put("certificate", PemUtils.encodeCertificate((Certificate)certificate));
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate certificate", t);
        }
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

