/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.Key;
import java.util.Collections;
import java.util.Map;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.PublicKeyLoader;

public class HardcodedPublicKeyLoader
implements PublicKeyLoader {
    private final String kid;
    private final String pem;

    public HardcodedPublicKeyLoader(String kid, String pem) {
        this.kid = kid;
        this.pem = pem;
    }

    public Map<String, KeyWrapper> loadKeys() throws Exception {
        return Collections.unmodifiableMap(Collections.singletonMap(this.kid, this.getSavedPublicKey()));
    }

    protected KeyWrapper getSavedPublicKey() {
        KeyWrapper keyWrapper = null;
        if (this.pem != null && !this.pem.trim().equals("")) {
            keyWrapper = new KeyWrapper();
            keyWrapper.setKid(this.kid);
            keyWrapper.setType("RSA");
            keyWrapper.setAlgorithm("RS256");
            keyWrapper.setUse(KeyUse.SIG);
            keyWrapper.setVerifyKey((Key)PemUtils.decodePublicKey((String)this.pem));
        }
        return keyWrapper;
    }
}

